//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXAPlayer.cpp
 * @brief		XAudio source t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXXAPlayer_CPP_

//======================================================================
// include
#include "AXXAPlayer.h"
#include "AXXAudio.h"
#include "../../iris_debug.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CXAPlayer::CXAPlayer(void)
: m_pSource(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CXAPlayer::~CXAPlayer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	pXAudio	= XAudio
 * @param [in]	pFormat	= Wave tH[}bg
 * @return	
*//***********************************************************************/
bool CXAPlayer::Initialize(CXAudio* pXAudio, const WAVEFORMATEX* pFormat)
{
	if( pXAudio == nullptr ) return false;
	LPXAUDIO2 xaudio = pXAudio->GetXAudio2();
	if( xaudio == nullptr ) return false;

	if( FAILED(xaudio->CreateSourceVoice(&m_pSource, pFormat) ) )
		return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CXAPlayer::Release(void)
{
	if( m_pSource != nullptr )
	{
		m_pSource->DestroyVoice();
		m_pSource = nullptr;
	}
}

/**********************************************************************//**
 *
 * obt@Zbg
 *
 ----------------------------------------------------------------------
 * @param [in]	pBuffer		= obt@
 * @param [in]	pBufferWMA	= obt@(WMA)
 * @return	
*//***********************************************************************/
bool CXAPlayer::Submit(const LPXAUDIO2_BUFFER pBuffer, const LPXAUDIO2_BUFFER_WMA pBufferWMA)
{
	if( m_pSource == nullptr ) return false;
	if( FAILED( m_pSource->SubmitSourceBuffer(pBuffer, pBufferWMA) ) )
		return false;
	return true;
}

/**********************************************************************//**
 *
 * Đ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CXAPlayer::Play(void)
{
	IRIS_ASSERT( m_pSource != nullptr );
	if( FAILED(m_pSource->Start()) )
		return false;
	return true;
}

/**********************************************************************//**
 *
 * ~
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CXAPlayer::Stop(void)
{
	IRIS_ASSERT( m_pSource != nullptr );
	if( FAILED(m_pSource->Stop()) )
		return false;
	return true;
}

/**********************************************************************//**
 *
 * Lǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CXAPlayer::IsValid(void) const
{
	return (m_pSource != nullptr);
}

/**********************************************************************//**
 *
 * {[擾
 *
 ----------------------------------------------------------------------
 * @return	{[
*//***********************************************************************/
f32 CXAPlayer::GetVolume(void)	const
{
	IRIS_ASSERT( m_pSource != nullptr );
	f32 volume = 0.f;
	m_pSource->GetVolume(&volume);
	return volume;
}

/**********************************************************************//**
 *
 * {[ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	volume			= {[
 * @param [in]	OperationSet	= xob`w
 * @return	
*//***********************************************************************/
bool CXAPlayer::SetVolume(f32 volume, u32 OperationSet)
{
	IRIS_ASSERT( m_pSource != nullptr );
	if( FAILED(m_pSource->SetVolume(volume, OperationSet)) )
		return false;
	return true;
}

/**********************************************************************//**
 *
 * Ԃ̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pState		= 
*//***********************************************************************/
void CXAPlayer::GetState(LPXAUDIO2_VOICE_STATE pState)	const
{
	IRIS_ASSERT( m_pSource != nullptr );
	IRIS_ASSERT( pState != nullptr );
	m_pSource->GetState(pState);
}

/**********************************************************************//**
 *
 * L[ɂobt@擾
 *
 ----------------------------------------------------------------------
 * @return obt@
*//***********************************************************************/
u32 CXAPlayer::GetBuffersQueued(void)	const
{
	XAUDIO2_VOICE_STATE state;
	GetState(&state);
	return state.BuffersQueued;
}

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../unit/UnitCore.h"
#include "AXXABuffer.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

#define TEST_MP3

#ifdef TEST_MP3
#include "../../platform/windows/win/mmsystem/WXMMMP3File.h"
#endif

//======================================================================
// test
IRIS_UNITTEST(CAXXAPlayerUnitTest, Func)
{
	CXAudio xaudio;
	CXAPlayer player;
	CXABuffer<> buffer;
	WAVEFORMATEX wfex;
	WAVEFORMATEX* pwfex = &wfex;
	CHAR fname[MAX_PATH] = "../../data/snd/sample.mp3";
#ifndef _IRIS_SUPPORT_AUTO_UNITTEST
	std::cout << "t@CpX͂ĂB" << std::endl;
	std::cin >> fname;
#endif

#ifdef TEST_MP3
	CMMMP3File file;
	if( !file.OpenA(fname) )
	{
		std::cerr << "t@CJ܂łB" << std::endl;
		return;
	}
	pwfex = file.GetWaveFormatEx();
	buffer.Initialize();
	buffer.SetFile(&file);
	buffer.Read();
	buffer.GetXAudio2Buffer()->Flags = XAUDIO2_END_OF_STREAM;
#endif

	xaudio.Initialize();
	player.Initialize(&xaudio, pwfex);
	player.Submit(buffer.GetXAudio2Buffer());

	player.Play();

	std::cout << "͂Œ~" << std::endl;
	std::cin >> fname;

	player.Stop();

	return;
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

#endif
