//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXXABuffer.h
 * @brief		XAudio buffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXXABuffer_H_
#define INCG_IRIS_AXXABuffer_H_

//======================================================================
// include
#include "../format/AXAudioBuffer.h"
#include "xaudio_inchead.h"

#if	defined(_IRIS_SUPPORT_XAUDIO2)

namespace iris {
namespace ax {
namespace xaudio
{

//======================================================================
// class
/**
 * @ingroup	XAudio
 * @brief	XAudio Buffer
*/
template< typename Allocator_ = CNewAllocator<u8> >
class CXABuffer : public CAXBuffer< Allocator_ >
{
	typedef CAXBuffer< Allocator_ >	_Mybase;
protected:
	XAUDIO2_BUFFER	m_Buffer;	//!< XAudio2 buffer
public:
	// RXgN^
	CXABuffer(void)	{}
	explicit CXABuffer(IAXFile* pFile) : _Mybase(pFile) {}

public:
	/// 
	virtual	void	Initialize(void)
	{
		m_Buffer.PlayBegin	= 0;
		m_Buffer.PlayLength	= 0;
		m_Buffer.LoopBegin	= 0;
		m_Buffer.LoopLength	= 0;
		m_Buffer.Flags		= 0;
		m_Buffer.LoopCount	= XAUDIO2_NO_LOOP_REGION;
	}

public:
	// f[^̓Ǎ
	virtual	bool	Read(u32 uSize)
	{
		if( !_Mybase::Read(uSize) ) return false;
		m_Buffer.AudioBytes = m_ReadSize;
		m_Buffer.pAudioData = static_cast<const BYTE*>(m_pBuffer);
		return true;
	}
	virtual	bool	Read(void)
	{
		return _Mybase::Read();
	}

public:
	LPXAUDIO2_BUFFER	GetXAudio2Buffer(void)	{ return &m_Buffer; }
};

}	// end of namespace xaudio
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
