//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXCdaFile.cpp
 * @brief		cda t@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXCdaFile_CPP_

//======================================================================
// inculde
#include "AXCdaFile.h"
#include "../../../iris_debug.h"

#if defined(_IRIS_SUPPORT_WDK)
#include "../../../platform/windows/win/shell/WXShellPath.h"

namespace iris {
namespace ax
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CCdaFile::CCdaFile(void)
: m_Size(0)
, m_SectorIndex(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CCdaFile::~CCdaFile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CCdaFile::OpenA(LPCSTR  fname)
{
	if( !m_Format.Open(fname) ) return false;

	// pXhCuԍ擾
	wx::CPathA path(fname);
	int driveNumber = path.GetDriveNumber();
	if( driveNumber == -1 )
	{
		path.SearchAndQualify(fname);
		driveNumber = path.GetDriveNumber();
	}
	if( driveNumber == -1 || (wx::CDrive::GetDriveType(driveNumber) != DRIVE_CDROM) )
	{
		driveNumber = wx::CDrive::FindDrive(DRIVE_CDROM);
	}
	return OpenDrive(driveNumber);
}
/// CCdaFile::OpenA Q
bool CCdaFile::OpenW(LPCWSTR fname)
{
	if( !m_Format.Open(fname) ) return false;

	// pXhCuԍ擾
	wx::CPathW path(fname);
	int driveNumber = path.GetDriveNumber();
	if( driveNumber == -1 )
	{
		path.SearchAndQualify(fname);
		driveNumber = path.GetDriveNumber();
	}
	if( driveNumber == -1 || (wx::CDrive::GetDriveType(driveNumber) != DRIVE_CDROM) )
	{
		driveNumber = wx::CDrive::FindDrive(DRIVE_CDROM);
	}
	return OpenDrive(driveNumber);
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CCdaFile::IsOpen(void) const
{
	if( m_Size == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CCdaFile::Close(void)
{
	m_File.Stop();
	m_File.Close();
	m_Size = 0;
	m_SectorIndex = 0;
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	length		= o̓obt@TCY
 * @return	WJobt@TCY
*//***********************************************************************/
u32 CCdaFile::ReadPCM(void* lpBuffer, u32 size)
{
	u32 nSector = size / CD_RAW_SECTOR_SIZE;				// ǂݏoZN^
	u32 nRemain = m_Format->LengthHsg - m_SectorIndex;		// ǂݏo\ȃZN^
	if( nRemain < nSector ) nSector = nRemain;
	u32 nSectorPos = m_Format->StartHsg + m_SectorIndex;
	if( nSector < 1 ) return 0;
	LONGLONG DiskOffset = nSectorPos * m_SectorSize;
	u32 dwRead = 0;
	if( m_File.ReadRawData(lpBuffer, size, &dwRead, CDDA, DiskOffset, nSector) )
	{
		m_SectorIndex += nSector;
	}
	return dwRead;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CCdaFile::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	if( pwfex == nullptr ) return false;
	if( m_Size == 0 ) return false;
	pwfex->cbSize			= sizeof(WAVEFORMATEX);
	pwfex->nChannels		= CHANNELS;
	pwfex->nSamplesPerSec	= SAMPLING_RATE;
	pwfex->wBitsPerSample	= BITS_WIDTH;
	pwfex->nBlockAlign		= pwfex->wBitsPerSample * pwfex->nChannels / 8u;
	pwfex->nAvgBytesPerSec	= pwfex->nBlockAlign * pwfex->nSamplesPerSec;
	pwfex->wFormatTag		= WAVE_FORMAT_PCM;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CCdaFile::Tell(void)	const
{
	u32 pos = m_SectorIndex * CD_RAW_SECTOR_SIZE;
	return static_cast<s32>(pos / (BITS_WIDTH * CHANNELS));
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CCdaFile::TellTime(void)	const
{
	s32 samples = Tell();
	if( samples == -1 ) return 0.0f;
	return (f64)samples / SAMPLING_RATE;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	samples	= TvP
 * @return	
*//***********************************************************************/
bool CCdaFile::Seek(s32 samples)
{
	s32 pos = samples * BITS_WIDTH * CHANNELS;
	u32 nSector = static_cast<u32>(pos / CD_RAW_SECTOR_SIZE);
	m_SectorIndex = nSector;
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CCdaFile::SeekTime(f64 time)
{
	s32 samples = static_cast<s32>(time * SAMPLING_RATE);
	return Seek(samples);
}

/**********************************************************************//**
 * @internal
 *
 * hCu I[v
 *
 ----------------------------------------------------------------------
 * @param [in]	driveNumber	= hCuԍ
 * @return	
*//***********************************************************************/
bool CCdaFile::OpenDrive(int driveNumber)
{
	if( driveNumber == -1 ) return false;
	if( m_File.GetDriveType(driveNumber) != DRIVE_CDROM ) return false;
#if 1
	TCHAR szDrive[7];
	if( !m_File.GetDriveAccessPath(driveNumber, szDrive, 7) ) return false;
#else
	TCHAR szDrive[] = IRIS_TEXT("\\\\.\\ :");
	szDrive[4] = IRIS_TEXT('A') + driveNumber;
#endif
	if( !m_File.Open(szDrive, GENERIC_READ, FILE_SHARE_READ, nullptr
		, OPEN_EXISTING, FILE_ATTRIBUTE_READONLY|FILE_FLAG_SEQUENTIAL_SCAN, nullptr) ) return false;
	m_SectorIndex = 0;
	m_Size = m_Format.GetSize();
	m_SectorSize = m_File.GetSectorSize();
	return true;
}

}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../../al/AXALSystem.h"
#include "../../al/AXALBuffer.h"
#include "../../al/AXALPlayer.h"
#include "../AXAudioBuffer.h"
#include "../../../fnd/memory/FndMemBuffer.h"
#include "AXWavFile.h"
#include <stdio.h>
#include <tchar.h>
#include "iris_iostream.h"
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CAXCdaFileUnitTest, Func)
{
	static const int STREAM_BUFFER_NUM	= 2;
	static const int STREAM_BUFFER_SIZE	= 4*CD_RAW_SECTOR_SIZE;

	CCdaFile cdafile;
#ifdef _IRIS_SUPPORT_OPENAL
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[STREAM_BUFFER_NUM];
#endif

	TCHAR fname[MAX_PATH] = IRIS_TEXT("../../../data/snd/sample.wav");
#if 1
	std::cout << "J cda t@C͂ĂB" << std::endl;
	std::tcin >> fname;
#endif
	if( !cdafile.Open(fname) )
	{
		return;
	}
	_tprintf(IRIS_TEXT("file open %s.\n"), fname);

	const fnd::CDDA_FMT_CHUNK&	fmt = cdafile.GetFormatChunk();
	printf("wav info.\n");
	printf("FileVersion    %d\n", fmt.FileVersion);
	printf("NumberOfTrack  %d\n", fmt.NumberOfTrack);
	printf("SerialNumber   %d\n", fmt.SerialNumber);
	printf("StartHsg       %d\n", fmt.StartHsg);
	printf("LengthHsg      %d\n", fmt.LengthHsg);
	printf("StartRedBook   %d\n", fmt.StartRedBook);
	printf("LengthRedBook  %d\n", fmt.LengthRedBook);

#if	defined(_IRIS_SUPPORT_OPENAL)
	{
		WAVEFORMATEX wfex;
		cdafile.GetWaveFormatEx(&wfex);
		system.Initialize();
		player.Initialize();

		printf("wav info.\n");
		printf("channels       %d\n", wfex.nChannels);
		printf("SampleFrames   %d\n", wfex.nSamplesPerSec);
		printf("BitsPerSamples %d\n", wfex.wBitsPerSample);

		printf("play streaming.\n");

		CAXBuffer<> data[STREAM_BUFFER_NUM];
		for( int i=0; i < STREAM_BUFFER_NUM; ++i )
		{
			data[i].SetFile(&cdafile);
			data[i].Read(STREAM_BUFFER_SIZE);
			buffer[i].Initialize();
			buffer[i].BindData(data[i], data[i].GetReadSize(), wfex.nChannels, wfex.nSamplesPerSec);

			player.StreamOut(&buffer[i], TRUE);
		}
		player.SetLoop(FALSE);
		player.Play();

		while( player.IsPlay() )
		{
			if( player.GetProcessedBufferNum() > 0 || player.GetQueueBufferNum() < STREAM_BUFFER_NUM )
			{
				player.Dequeue(1);
				for( int i=0; i < STREAM_BUFFER_NUM; ++i )
				{
					if( !buffer[i].IsRegistPlayer() )
					{
						if( !data[i].Read() ) break;
						buffer[i].BindData(data[i], data[i].GetReadSize(), wfex.nChannels, wfex.nSamplesPerSec);
						player.StreamOut(&buffer[i], TRUE);
						player.Play();
						break;
					}
				}
			}
		}
	}
#endif
}

IRIS_UNITTEST(CAXCdaFileUnitTest, Ripping)
{
	CCdaFile cdafile;

	TCHAR fname[MAX_PATH] = IRIS_TEXT("../../../data/snd/sample.wav");
#if 1
	std::cout << "J cda t@C͂ĂB" << std::endl;
	std::tcin >> fname;
#endif
	if( !cdafile.Open(fname) )
	{
		return;
	}

	fnd::CFile file;
	_tcscat_s(fname, IRIS_TEXT(".wav"));
	ASSERT_TRUE( file.Open(fname, fnd::FOPEN_WRITE) );

	u8 buf[CD_RAW_SECTOR_SIZE*32];
	ASSERT_TRUE( CWavFile::WriteFile(&file, &cdafile, buf, sizeof(buf)) );
}

#endif

#endif
