//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXOggVorbisFile.h
 * @brief		oggt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXOggVorbisFile_H_
#define INCG_IRIS_AXOggVorbisFile_H_

#ifdef _IRIS_SUPPORT_OGGVORBIS

//======================================================================
// inculde
#include "../AXAudioFile.h"
#include "vorbis/vorbisfile.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/**
 * Oggvorbis t@CNX
*/
class COggFile : public IAXFile
{
protected:
	mutable	OggVorbis_File	m_File;	//!< t@C\

public:
	// RXgN^
	COggFile(void);
	// fXgN^
	~COggFile(void);

public:
	// J
	virtual	bool	OpenA(LPCSTR  fname);
	virtual	bool	OpenW(LPCWSTR fname);
	virtual bool	IsOpen(void)	const;

	// 
	virtual	void	Close(void);

public:
	// pcmf[^̓ǂݎ
	s32				Decode(char* lpBuffer, int length, int sgned, int* bitstream);
	// PCMf[^̓ǂݎ
	virtual u32		ReadPCM(void* lpBuffer, u32 size);

	// WAVEFORMATEX̎擾
	virtual	bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;
	// f[^TCY̎擾
	virtual	u32		GetSize(void)	const;
	// PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const;
public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);

public:
	// t@C̎擾
	vorbis_info*	GetInfo(int link=-1) const;

	// Rg擾
	vorbis_comment*	GetComment(int link=-1) const;
};


}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
