//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXOggVorbisError.cpp
 * @brief		oggG[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXOggVorbisError_CPP_

#ifdef _IRIS_SUPPORT_OGGVORBIS

//======================================================================
// inculde
#include "AXOggVorbisError.h"
#include "vorbis/vorbisfile.h"
#include "../../../iris_xchar.hpp"

namespace iris {
namespace ax
{

//======================================================================
// define
#define TEXTA(t)	t
#define TEXTW(t)	L##t

#define SWITCH_ERROR_MESSAGE_(text)							\
	switch( error )											\
	{														\
	case OV_OK:												\
		xcscpy_s(lpBuf, size, text("OV_OK"));				\
		break;												\
															\
	case OV_FALSE:											\
		xcscpy_s(lpBuf, size, text("OV_FALSE"));			\
		break;												\
	case OV_EOF:											\
		xcscpy_s(lpBuf, size, text("OV_EOF"));				\
		break;												\
	case OV_HOLE:											\
		xcscpy_s(lpBuf, size, text("OV_HOLE"));				\
		break;												\
															\
	case OV_EREAD:											\
		xcscpy_s(lpBuf, size, text("OV_EREAD"));			\
		break;												\
	case OV_EFAULT:											\
		xcscpy_s(lpBuf, size, text("OV_EFAULT"));			\
		break;												\
	case OV_EIMPL:											\
		xcscpy_s(lpBuf, size, text("OV_EIMPL"));			\
		break;												\
	case OV_EINVAL:											\
		xcscpy_s(lpBuf, size, text("OV_EINVAL"));			\
		break;												\
	case OV_ENOTVORBIS:										\
		xcscpy_s(lpBuf, size, text("OV_ENOTVORBIS"));		\
		break;												\
	case OV_EBADHEADER:										\
		xcscpy_s(lpBuf, size, text("OV_EBADHEADER"));		\
		break;												\
	case OV_EVERSION:										\
		xcscpy_s(lpBuf, size, text("OV_EVERSION"));			\
		break;												\
	case OV_ENOTAUDIO:										\
		xcscpy_s(lpBuf, size, text("OV_ENOTAUDIO"));		\
		break;												\
	case OV_EBADPACKET:										\
		xcscpy_s(lpBuf, size, text("OV_EBADPACKET"));		\
		break;												\
	case OV_EBADLINK:										\
		xcscpy_s(lpBuf, size, text("OV_EBADLINK"));			\
		break;												\
	case OV_ENOSEEK:										\
		xcscpy_s(lpBuf, size, text("OV_ENOSEEK"));			\
		break;												\
}

//======================================================================
// xcscpy_stion
/**********************************************************************//**
 *
 * G[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	error	= G[l
 * @param [out]	lpBuf	= o̓obt@
 * @param [in]	size	= o̓obt@TCY
*//***********************************************************************/
template<>
void	AXOVFormatMessage<CHAR>(int error, LPSTR  lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	SWITCH_ERROR_MESSAGE_(TEXTA);
}
/**
 * @ref	AXOVFormatMessage
*/
template<>
void	AXOVFormatMessage<WCHAR>(int error, LPWSTR lpBuf, size_t size)
{
	if( lpBuf == nullptr ) return;
	SWITCH_ERROR_MESSAGE_(TEXTW);
}

}	// end of namespace ax
}	// end of namespace iris

#endif
