//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAIFF.h
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXAIFF_H_
#define INCG_IRIS_AXAIFF_H_

//======================================================================
// include
#include "../AXAudioFile.h"
#include "../../../fnd/io/FndFile.h"
#include "../../../fnd/format/FndAIFF.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/// AIFFtH[}bgt@CNX
class CAIFF : public IAXFile
{
protected:
	fnd::CAIFF<fnd::CFile>	m_File;		//!< t@C
	fnd::AIFF_FILE_CHUNK	m_Header;	//!< t@C`N
	WAVEFORMATEX			m_Format;	//!< tH[}bg

	s32						m_Offset;	//!< f[^܂ł̃ItZbg
	u32						m_Size;		//!< f[^TCY
public:
	// RXgN^
	CAIFF(void);
	// fXgN^
	virtual ~CAIFF(void);
public:
	// J
	virtual	bool	OpenA(LPCSTR  fname) override;
	virtual	bool	OpenW(LPCWSTR fname) override;
	virtual bool	IsOpen(void)	const;

	// 
	virtual	void	Close(void) override;

public:
	// PCMf[^̓ǂݎ
	virtual u32		ReadPCM(void* lpBuffer, u32 size);

	// WAVEFORMATEX̎擾
	virtual bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const;

	/// wavf[^̃TCY擾
	virtual	u32		GetSize(void)		const	{ return m_Size; }
	/// PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const	{ return m_Size; }
public:
	// tell
	virtual s32		Tell(void)	const;
	// tell time
	virtual f64		TellTime(void)	const;
	// seek
	virtual	bool	Seek(s32 samples);
	// seek (time)
	virtual	bool	SeekTime(f64 time);

private:
	// I[vʏ
	bool	_Open(void);
};


}	// end of namespace ax
}	// end of namespace iris

#endif
