//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAIFF.cpp
 * @brief		AIFFtH[}bgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_AXAIFF_CPP_

//======================================================================
// include
#include "AXAIFF.h"

namespace iris {
namespace ax
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CAIFF::CAIFF(void)
: m_Offset(-1)
, m_Size(0)
{
	m_Format.cbSize			= sizeof(WAVEFORMATEX);
	m_Format.wFormatTag		= WAVE_FORMAT_PCM;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CAIFF::~CAIFF(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 ----------------------------------------------------------------------
 * @param [in]	fname	= t@CpX
 * @return	
*//***********************************************************************/
bool CAIFF::OpenA(LPCSTR  fname)
{
	if( !m_File.OpenA(fname) ) return false;
	return _Open();
}
/// CAIFF::OpenA Q
bool CAIFF::OpenW(LPCWSTR fname)
{
	if( !m_File.OpenW(fname) ) return false;
	return _Open();
}

/**********************************************************************//**
 *
 * JĂ邩ǂ
 *
*//***********************************************************************/
bool CAIFF::IsOpen(void) const
{
	if( m_Size == 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CAIFF::Close(void)
{
	m_File.Close();
	m_Offset = -1;
	m_Size = 0;
}

/**********************************************************************//**
 *
 * PCMf[^̓ǂݎ
 *
 ----------------------------------------------------------------------
 * @param [out]	lpBuffer	= o̓obt@
 * @param [in]	size		= o̓obt@TCY
 * @return	WJobt@TCY
*//***********************************************************************/
u32 CAIFF::ReadPCM(void* lpBuffer, u32 size)
{
	s32 pos = m_File.Tell() - m_Offset;
	IRIS_VERIFYRETURN( pos >= 0, 0 );
	if( pos + size > static_cast<u32>(m_Size) ) size = static_cast<u32>(m_Size - pos);
	u32 read = m_File.Read(lpBuffer, size);
	return read;
}

/**********************************************************************//**
 *
 * WAVEFORMATEX̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	pwfex	= WAVEFORMATEX
 * @return	
*//***********************************************************************/
bool CAIFF::GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const
{
	if( pwfex == nullptr ) return false;
	if( m_Size == 0 ) return false;
	*pwfex = m_Format;
	return true;
}

/**********************************************************************//**
 *
 * tell
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(TvP)
*//***********************************************************************/
s32 CAIFF::Tell(void)	const
{
	s32 pos = m_File.Tell();
	if( pos < m_Offset ) return -1;
	if( static_cast<u32>(pos) >= m_Offset + m_Size ) return -1;
	return (pos - m_Offset) / (m_Format.wBitsPerSample * m_Format.nChannels);
}

/**********************************************************************//**
 *
 * tell time
 *
 ----------------------------------------------------------------------
 * @return	V[Nʒu(bP)
*//***********************************************************************/
f64 CAIFF::TellTime(void)	const
{
	s32 samples = Tell();
	if( samples == -1 ) return 0.0f;
	return (f64)samples / m_Format.nSamplesPerSec;
}

/**********************************************************************//**
 *
 * seek
 *
 ----------------------------------------------------------------------
 * @param [in]	samples	= TvP
 * @return	
*//***********************************************************************/
bool CAIFF::Seek(s32 samples)
{
	s32 pos = samples * m_Format.wBitsPerSample * m_Format.nChannels;
	m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 *
 * seek time
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= bP
 * @return	
*//***********************************************************************/
bool CAIFF::SeekTime(f64 time)
{
	s32 samples = static_cast<s32>(time * m_Format.nSamplesPerSec);
	s32 pos = samples * m_Format.wBitsPerSample * m_Format.nChannels;
	 m_File.Seek(pos + m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

/**********************************************************************//**
 * @internal
 *
 * I[vʏ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CAIFF::_Open(void)
{
	if( m_File.GetFormType() != fnd::AIFF_ID_FORMTYPE ) return false;

	// format
	if( !m_File.Descend(fnd::AIFF_ID_COMM_CHUNK) ) return false;
	fnd::AIFF_COMM_CHUNK format;
	m_File.Read(&format, sizeof(fnd::AIFF_COMM_CHUNK));
	m_Format.nChannels			= format.Channels;
	m_Format.wBitsPerSample		= format.wBitsPerSample;
	m_Format.nBlockAlign		= (m_Format.wBitsPerSample * m_Format.nChannels) / 8u;
	double sample_rate = format.SampleRate;	// 80bit ieee -> dobule ɕϊĂ܂B
	m_Format.nSamplesPerSec		= static_cast<u32>(sample_rate);
	m_Format.nAvgBytesPerSec	= m_Format.nBlockAlign * m_Format.nSamplesPerSec;
	m_File.Ascend();

	// data
	if( !m_File.Descend(fnd::AIFF_ID_SSND_CHUNK) ) return false;
	fnd::AIFF_CHUNK_HEADER chunk;
	if( m_File.Read(&chunk, sizeof(fnd::AIFF_CHUNK_HEADER)) == 0 ) return false;
	m_Offset = m_File.Tell() + sizeof(fnd::AIFF_SSND_CHUNK);
	m_Size = chunk.Size;
	m_File.Ascend();

	m_File.Seek(m_Offset, fnd::FILE_SEEK_SET);
	return true;
}

}	// end of namespace ax
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../../unit/UnitCore.h"
#include "../../al/AXALSystem.h"
#include "../../al/AXALBuffer.h"
#include "../../al/AXALPlayer.h"
#include "../../../fnd/memory/FndMemBuffer.h"
#include <stdio.h>
#include "iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CAXAIFFUnitTest, Func)
{
	static const int STREAM_BUFFER_NUM	= 2;
	static const int STREAM_BUFFER_SIZE	= 8*1024;

	ax::CAIFF aiff;
#ifdef _IRIS_SUPPORT_OPENAL
	CALSystem system = CALSystem::CreateImplement();
	CALPlayer player;
	CALBuffer buffer[STREAM_BUFFER_NUM];
#endif

	CHAR fname[MAX_PATH] = "../../../data/snd/sample.aif";
	if( !aiff.Open(fname) )
	{
		printf("file open failed %s.\n", fname);
		return;
	}
	printf("file open %s.\n", fname);

#ifdef _IRIS_SUPPORT_OPENAL
	{
		WAVEFORMATEX wfex;
		aiff.GetWaveFormatEx(&wfex);
		system.Initialize();
		player.Initialize();

		printf("wav info.\n");
		printf("channels       %d\n", wfex.nChannels);
		printf("SampleFrames   %d\n", wfex.nSamplesPerSec);
		printf("BitsPerSamples %d\n", wfex.wBitsPerSample);

		printf("play streaming.\n");

		fnd::CMemBuffer data[STREAM_BUFFER_NUM];
		for( int i=0; i < STREAM_BUFFER_NUM; ++i )
		{
			data[i].Alloc(STREAM_BUFFER_SIZE);
			u32 size = aiff.ReadPCM(data[i], data[i].GetSize());
			buffer[i].Initialize();
			buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);

			player.StreamOut(&buffer[i], TRUE);
		}
		player.SetLoop(FALSE);
		player.Play();

		while( player.IsPlay() )
		{
			if( player.GetProcessedBufferNum() > 0 || player.GetQueueBufferNum() < STREAM_BUFFER_NUM )
			{
				player.Dequeue(1);
				for( int i=0; i < STREAM_BUFFER_NUM; ++i )
				{
					if( !buffer[i].IsRegistPlayer() )
					{
						u32 size = aiff.ReadPCM(data[i], data[i].GetSize());
						if( size == 0 ) break;
						buffer[i].BindData(data[i], size, wfex.nChannels, wfex.nSamplesPerSec);
						player.StreamOut(&buffer[i], TRUE);
						player.Play();
						break;
					}
				}
			}
		}
	}
#endif
}


#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
