//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXAudioFile.h
 * @brief		I[fBIt@CC^[tFCX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXAudioFile_H_
#define INCG_IRIS_AXAudioFile_H_

//======================================================================
// inculde
#include "../../iris_object.h"
#include "../../c++0x/cpp0x_enable_if.hpp"
#include "../../c++0x/cpp0x_type_traits.hpp"
#include "../../fnd/io/FndIFile.h"

//======================================================================
// struct
#if	!defined(_WAVEFORMATEX_)
#define _WAVEFORMATEX_
typedef IRIS_PACKED struct tWAVEFORMATEX
{
    IrisU16		wFormatTag;         /* format type */
    IrisU16		nChannels;          /* number of channels (i.e. mono, stereo...) */
    IrisU32		nSamplesPerSec;     /* sample rate */
    IrisU32		nAvgBytesPerSec;    /* for buffer estimation */
    IrisU16		nBlockAlign;        /* block size of data */
    IrisU16		wBitsPerSample;     /* number of bits per sample of mono data */
    IrisU16		cbSize;             /* the count in bytes of the size of */
                                    /* extra information (after cbSize) */
} WAVEFORMATEX, *PWAVEFORMATEX, NEAR *NPWAVEFORMATEX, FAR *LPWAVEFORMATEX;
#endif /* _WAVEFORMATEX_ */
#ifndef WAVE_FORMAT_PCM
#  define WAVE_FORMAT_PCM     1
#endif


namespace iris {
namespace ax
{

//======================================================================
// class
//! I[fBIt@CC^[tFCXNX
class IAXFile : public IIrisObject
{
public:
	// RXgN^
	IAXFile(void)	{}
	// fXgN^
	virtual ~IAXFile(void)	{}

public:
	// J
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* fname
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, CHAR> >::type*& =cpp0x::enabler::value)	{ return OpenA(fname); }
	template<typename CHARTYPE_>
	bool			Open(const CHARTYPE_* fname
		, typename enable_if_t< cpp0x::is_same<CHARTYPE_, WCHAR> >::type*& =cpp0x::enabler::value)	{ return OpenW(fname); }

	/**
	 * @name	ۃ\bh
	 * @{
	*/

	virtual	bool	OpenA(LPCSTR  fname) = 0;
	virtual	bool	OpenW(LPCWSTR fname) = 0;
	virtual bool	IsOpen(void)	const = 0;

	//! 
	virtual	void	Close(void) = 0;

public:
	//! PCMf[^̓ǂݎ
	virtual u32		ReadPCM(void* lpBuffer, u32 size)		= 0;

	//! WAVEFORMATEX̎擾
	virtual bool	GetWaveFormatEx(LPWAVEFORMATEX pwfex)	const	= 0;
	//! f[^TCY̎擾
	virtual	u32		GetSize(void)		const				= 0;
	//! PCMf[^TCY̎擾
	virtual u32		GetSizePCM(void)	const				= 0;

public:
	//! tell
	virtual s32		Tell(void)		const	= 0;
	//! tell time
	virtual f64		TellTime(void)	const	= 0;
	//! seek
	virtual	bool	Seek(s32 samples)		= 0;
	//! seek (time)
	virtual	bool	SeekTime(f64 time)		= 0;

	/**
	 * @}
	*/

public:
	/*
	 * @brief	t@Cɏ
	 * @param [in]	pFile		= ݐ̃t@CwiI[vĂKvj
	 * @param [in]	pAudio		= ̓I[fBIt@C
	 * @param [in]	buf			= Ɨpobt@
	 * @param [in]	work_size	= Ɨpobt@TCY
	*/
	static	bool	WriteFile(fnd::IFile* /*pFile*/, IAXFile* /*pAudio*/, void* /*buf*/, u32 /*work_size*/)	{ return false; }
};

}	// end of namespace ax
}	// end of namespace iris

#endif
