//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		AXALSystem.h
 * @brief		OpenAL SystemNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_AXALSystem_H_
#define INCG_IRIS_AXALSystem_H_

#ifdef _IRIS_SUPPORT_OPENAL

//======================================================================
// include
#include "../../iris_object.h"
#include "AXALTypes.h"

namespace iris {
namespace ax {
namespace al
{

//======================================================================
// class
/**
 * @ingroup	OpenAL
 * @brief	OpenALVXeNX
*/
class CALSystem : public IIrisObject
{
	class CImpl;
	CImpl*	m_pImpl;

public:
	// RXgN^
	CALSystem(void);
	// fXgN^
	~CALSystem(void);

	// 
	// RXgN^
    CALSystem(const CALSystem &rObject);
    // 
    CALSystem& operator = (CALSystem &rObject);

public:
	// 
	static CALSystem	CreateImplement(void);

public:
	// 
	bool	Initialize(LPCAXALSTR deviceSpecifier=nullptr);
	// 
	bool	InitializeEx(LPCAXALSTR deviceSpecifier=nullptr, LPCAXALCONTEXTATTR lpCntxAttr=nullptr);
	// I
	void	Release(void);

public:
	// ÕG[R[h擾
	static AXALRESULT	GetLastError(void);
};

}	// end of namespace al
}	// end of namespace ax
}	// end of namespace iris

#endif

#endif
