//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_squirrel.cpp
 * @brief		squirrel eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_squirrel_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "script/squirrel/SqVM.h"
#include "iris_iostream.h"
#include "iris_global.h"
#include "iris_using.h"
#include <tchar.h>

TEST(SquirrelTest, Interpreter)
{
	CSquirrelVM sq;
	sq.Open(4096);

	ASSERT_TRUE( SQ_SUCCEEDED(sq.DoFile(_SC("../../../../data/script/squirrel/hello.nut"), SQFalse, SQTrue)) );
}

TEST(SquirrelTest, Functor)
{
	CSquirrelVM sq;
	SQChar path[MAX_PATH] = _SC("../../../../data/script/squirrel/foo.nut");
	sq.Open(4096);
	ASSERT_TRUE( SQ_SUCCEEDED(sq.DoFile(path, SQFalse)) );

	{
		CSqFunctor func = sq.Func(_SC("hello"));
		ASSERT_TRUE( func.IsValid() );
		ASSERT_TRUE( SQ_SUCCEEDED( func.Call(SQFalse) ) );
		func.GetReturnValue<void>();
	}

	{
		CTSqFunctor<SQInteger> func = sq.Func(_SC("add"));
		ASSERT_TRUE( func.IsValid() );
		SQInteger ret = func.Exec(101, 7);
		ASSERT_EQ( 108, ret );
	}

	{
		CTSqFunctor<SQFloat> func = sq.Func(_SC("add"));
		ASSERT_TRUE( func.IsValid() );
		SQFloat ret = func.Exec(2.0f, 1.2f);
		ASSERT_EQ( 3.2f, ret );
	}
}

TEST(SquirrelTest, Compile)
{
	CSquirrelVM sq;
	sq.Open(4096);
	ASSERT_TRUE( SQ_SUCCEEDED(sq.Compile(_SC("../../../../data/script/squirrel/foo.nut"))) );
}

