//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_stdc.cpp
 * @brief		test_stdc t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_stdc_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/random/RndSTDC.h"
#include "math/random/RndEvaluater.h"
#include "iris_iostream.h"
#include "iris_using.h"

typedef CSTDCRand	CTestRandom;

TEST(STDCTest, Generate)
{
	CTestRandom rnd;
	rnd.SetSeed(2);
	u32 r1 = rnd.GenRand32();
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(1);
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(2);
	ASSERT_EQ(r1, rnd.GenRand32());
}

TEST(STDCTest, MonoTest)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	int x = 0;
	//eval.MonoTest(&x);
	EXPECT_TRUE( eval.MonoTest(&x) );

	std::cout << x << std::endl;
}

TEST(STDCTest, Equiprobability)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	f32 x = 0;
	EXPECT_TRUE( eval.Equiprobability(&x) );

	std::cout << x << std::endl;
}

