//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_sfmt19937.cpp
 * @brief		test_sfmt19937 t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_sfmt19937_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/random/RndSFMT.h"
#include "math/random/RndEvaluater.h"
#include "iris_iostream.h"
#include "iris_using.h"

typedef CSFMT<19937>	CTestRandom;

TEST(SFMT19937Test, Generate)
{
	CTestRandom rnd;
	rnd.SetSeed(2);
	u32 r1 = rnd.GenRand32();
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(1);
	ASSERT_NE(r1, rnd.GenRand32());
	rnd.SetSeed(2);
	ASSERT_EQ(r1, rnd.GenRand32());
}

TEST(SFMT19937Test, MonoTest)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	int x = 0;
	EXPECT_TRUE( eval.MonoTest(&x) );

	std::cout << x << std::endl;
}

TEST(SFMT19937Test, Equiprobability)
{
	CTestRandom gen;
	CEvaluater eval(&gen);
	f32 x = 0;
	EXPECT_TRUE( eval.Equiprobability(&x) );

	std::cout << x << std::endl;
}

TEST(SFMT19937Test, example)
{
	CTestRandom gen;
	static const int NUM = 10;
	static const int GENNUM = 1000000;
	int count[NUM] = {0};

	for( int i=0; i < GENNUM; ++i )
	{
		int n = gen.GenRand31() % NUM;
		++count[n];
	}

	for( int i=0; i < NUM; ++i )
	{
		printf("%d : %d\t(%f%%)\n", i, count[i], count[i]/(float)GENNUM);
	}
}
