
/*
 * is not available vprintf, can be replaced.
*/
//#define IUTEST_VPRINTF

/*
 * include testing framework
*/
#define IUTEST_VPRINTF	iutest::nacl::vprint_message
#define IUTEST_PRINTF	iutest::nacl::print_message

#include "iutest.hpp"
//#include "gtest/iutest_switch.hpp"


class FooEnvironment : public iutest::Environment
{
	virtual void	SetUp(void)
	{
		iuutil::Console::output("FooEnvironment::SetUp\n");
	}
	virtual void	TearDown(void)
	{
		iuutil::Console::output("FooEnvironment::TearDown\n");
	}
};

int iutest_main(std::vector<std::string> argv)
{
#if 0
	iutest::detail::auto_ptr<iutest::Environment> env = iutest::AddGlobalTestEnvironment(new FooEnvironment());
	FooEnvironment env2;
	iutest::AddGlobalTestEnvironment(&env2);
#endif

	//iutest::IUTEST_FLAG(shuffle) = false;
	//iutest::IUTEST_FLAG(throw_on_failure) = true;
	iutest::InitIrisUnitTest(argv);
	return IUTEST_RUN_ALL_TESTS();	// run all
}

//#define SHOW_FAILURE

#if 1	// Success Tests

/**
 * ȒPȃeXg
*/
IUTEST(Test, Version)
{
	unsigned long v = (IUTEST_MAJORVER << 24) | (IUTEST_MINORVER << 16) | (IUTEST_BUILD << 8) | IUTEST_REVISION;
	IUTEST_ASSERT_EQ( IUTEST_VER, v );
}

IUTEST(Test, Test1)
{
	IUTEST_ASSERT_STREQ("Test1", iutest::UnitTest::GetInstance()->current_test_info()->name());
}

IUTEST(Test, Test2)
{
	IUTEST_SUCCEED() << "OK!!";
	IUTEST_SUCCEED() << L"OK!!";
}

/**
 * eXgݒ̗p
*/
class TestFixed : public iutest::Test
{
protected:
	static int x;
public:
	virtual void SetUp(void)
	{
		++x;
	}
	static void SetUpTestCase(void)
	{
		x = 0;
	}
};
int TestFixed::x = -1;

IUTEST_F(TestFixed, Test1)
{
	IUTEST_ASSERT_EQ(1, x);
}

IUTEST_F(TestFixed, Test2)
{
	IUTEST_ASSERT_EQ(2, x);
}

typedef TestFixed TestFixed2;

IUTEST_F(TestFixed2, Test1)
{
	IUTEST_ASSERT_EQ(1, x);
}

IUTEST_F(TestFixed2, Test2)
{
	IUTEST_ASSERT_EQ(2, x);
}

#if IUTEST_HAS_PARAM_TEST
/**
 * p[^eXg
*/
// Param Test Range
class TestP : public iutest::TestWithParam<int>
{
protected:
	static int a;
	static int b;
public:
	static void SetUpTestCase(void)
	{
		a = 0;
		b = 0;
	}
};
int TestP::a = 0;
int TestP::b = 0;

IUTEST_INSTANTIATE_TEST_CASE_P(TestPInstance, TestP, iutest::Range<int>(0, 10));

IUTEST_P(TestP, TestA)
{
	IUTEST_ASSERT_EQ(a, GetParam());
	++a;
}

IUTEST_P(TestP, TestB)
{
	IUTEST_ASSERT_EQ(b, GetParam());
	++b;
}

// Param Test Bool
class TestBool : public iutest::TestWithParam<bool> {};
IUTEST_INSTANTIATE_TEST_CASE_P(TestBoolInstance, TestBool, iutest::Bool());

IUTEST_P(TestBool, TestA)
{
	static bool x=false;
	IUTEST_ASSERT_EQ(x, GetParam());
	x = !x;
}

// Param Test ValueIn
const char ValueInTestText[] = "ValueInTestText";
class TestPValueIn : public iutest::TestWithParam<char>
{
protected:
	static int a;
public:
	static void SetUpTestCase(void)
	{
		a = 0;
	}
};
int TestPValueIn::a = 0;
IUTEST_INSTANTIATE_TEST_CASE_P(TestPValueInInstance, TestPValueIn, iutest::ValuesIn(ValueInTestText));

IUTEST_P(TestPValueIn, TestA)
{
	IUTEST_ASSERT_EQ(ValueInTestText[a++], GetParam());
}

// Param Test Values
class TestPValues1 : public iutest::TestWithParam<float> {};
IUTEST_INSTANTIATE_TEST_CASE_P(TestPValues1Instance, TestPValues1, iutest::Values(1.0f));

IUTEST_P(TestPValues1, TestA)
{
	IUTEST_ASSERT_FLOAT_EQ(1.0f, GetParam());
}

class TestPValuesN : public iutest::TestWithParam<int>
{
protected:
	static int a;
public:
	static void SetUpTestCase(void)
	{
		a = 1;
	}
};
int TestPValuesN::a = 1;
IUTEST_INSTANTIATE_TEST_CASE_P(TestPValuesNInstance, TestPValuesN, iutest::Values(1, 2, 3, 4, 5, 6, 7, 8, 9
																	//, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19
																	//, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29
																	//, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39
																	//, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49
																	//, 50
																	));

IUTEST_P(TestPValuesN, TestA)
{
	IUTEST_ASSERT_EQ(a++, GetParam());
}

#if IUTEST_HAS_COMBINE

class TestPCombine : public iutest::TestWithParam< std::tr1::tuple<bool, int, int> >
{
};

IUTEST_P(TestPCombine, TestA)
{
	bool b = ::std::tr1::get<0>(GetParam());
	int i1 = ::std::tr1::get<1>(GetParam());
	int i2 = ::std::tr1::get<2>(GetParam());
	IUTEST_SUCCEED() << b << ", " << i1 << ", " << i2;
}

IUTEST_INSTANTIATE_TEST_CASE_P(TestPCombineInstance, TestPCombine
							   , iutest::Combine( iutest::Bool(), iutest::Values(1, 2), iutest::Values(10, 11) ) );
#endif

#endif

/**
 * eeXg}N
*/
// operator Test
IUTEST(TestOp, EQ)
{
	int x=0, y=0;
	IUTEST_ASSERT_EQ(x, y);
	int* zero=NULL;
	IUTEST_ASSERT_EQ(NULL, zero);
	int* one=(int*)1;
	IUTEST_ASSERT_NE(NULL, one);
}

IUTEST(TestOp, NE)
{
	int x=0, y=1;
	IUTEST_ASSERT_NE(x, y);
}

IUTEST(TestOp, LE)
{
	{
		unsigned long x=1, y=1;
		IUTEST_ASSERT_LE(x, y);
	}
	{
		double x=0, y=1;
		IUTEST_ASSERT_LE(x, y);
	}
}

IUTEST(TestOp, LT)
{
	double x=0, y=1;
	IUTEST_ASSERT_LT(x, y);
}

IUTEST(TestOp, GE)
{
	{
		unsigned long x=1, y=1;
		IUTEST_ASSERT_GE(2u, x);
		IUTEST_ASSERT_GE(2u, y);
	}
	{
		double x=0, y=1;
		IUTEST_ASSERT_GE(y, x);
	}
}

IUTEST(TestOp, GT)
{
	double x=0, y=1;
	IUTEST_ASSERT_GT(y, x);
}

IUTEST(TestOp, FloatEQ)
{
	float x=1, y=1;
	IUTEST_ASSERT_FLOAT_EQ(y, x);
	IUTEST_ASSERT_FLOAT_EQ(-1.0f, -2.0f/2.0f);
}

IUTEST(TestOp, DoubleEQ)
{
	double x=1, y=1;
	IUTEST_ASSERT_DOUBLE_EQ(y, x);
	IUTEST_ASSERT_DOUBLE_EQ(-1.0, -2.0/2.0);
}

IUTEST(TestOp, Near)
{
	IUTEST_ASSERT_NEAR(0, 1, 2);
	IUTEST_ASSERT_NEAR(1.0f, 4.0f, 4);
	IUTEST_ASSERT_NEAR(2.0, 1.0, 2);
}


IUTEST(TestOp, STREQ)
{
	const char e[] = "test";
	IUTEST_ASSERT_STREQ(e, "test");
}

IUTEST(TestOp, STRNE)
{
	const wchar_t e[] = L"test";
	IUTEST_ASSERT_STRNE(e, L"tset");
}

IUTEST(TestOp, STRLNEQ)
{
	const wchar_t e[] = L"test";
	IUTEST_ASSERT_STRLNEQ(4, e);
}

IUTEST(TestOp, OREQ)
{
	int x=1;
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 1);
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::NE>::Comp, x, 0);
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::LE>::Comp, x, 1);
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::LT>::Comp, x, 2);
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::GE>::Comp, x, 1);
	IUTEST_ASSERT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::GT>::Comp, x, 0);
	IUTEST_ASSERT_PRED_FORMAT3(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 1, 0);
	IUTEST_ASSERT_PRED_FORMAT3(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 0, 1);
	IUTEST_ASSERT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 1, 2, 0);
	IUTEST_ASSERT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 0, 1, 2);
	IUTEST_ASSERT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 2, 0, 1);
	IUTEST_ASSERT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 1, 2, 3, 0);
	IUTEST_ASSERT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 0, 1, 2, 3);
	IUTEST_ASSERT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 3, 0, 1, 2);
	IUTEST_ASSERT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, x, 2, 3, 0, 1);
}

/**
 * qAT[V
*/
static bool IsOdd(int val)
{
	return (val & 1) != 0;
}
static bool	IsGreater(int a, int b)
{
	return a > b;
}

IUTEST(TestOp, Pred)
{
	IUTEST_ASSERT_PRED1(IsOdd, 3);
	IUTEST_ASSERT_PRED2(IsGreater, 3, 1);
}

/**
 * Diabled eXg
*/
// ̃eXg͖eXg
IUTEST(TestDisabled, DISABLED_Test1)
{
	IUTEST_ASSERT_TRUE(false);
}

IUTEST(TestDisabled, Test2)
{
	IUTEST_ASSERT_TRUE(true);
}

// eXgP[XׂĂ𖳌ɂ
IUTEST(DISABLED_TestCaseDisabled, Test1)
{
	IUTEST_ASSERT_TRUE(false);
}
IUTEST(DISABLED_TestCaseDisabled, Test2)
{
	IUTEST_ASSERT_TRUE(false);
}

/**
 * OAT[V
*/
#if IUTEST_HAS_EXCEPTIONS

static void	Exception(int i)
{
	switch( i )
	{
	case 0:
		return;
	case 1:
		throw 2;
		break;
	case 2:
		throw std::bad_exception();
		break;
	default:
		break;
	}
}

IUTEST(TestOp, Exception)
{
	//IUTEST_ASSERT_THROW(throw std::bad_exception(), std::bad_exception);
	IUTEST_ASSERT_THROW(Exception(2), std::bad_exception);
	IUTEST_ASSERT_ANY_THROW(Exception(1));
	IUTEST_ASSERT_NO_THROW(Exception(0));
}

class exception_test
{
public:
	exception_test(const std::vector<int>&)
	{
		IUTEST_SUPPRESS_UNREACHABLE_CODE_WARNING(throw std::exception());
	}
};

IUTEST(TestOp, Exception2)
{
	std::vector<int> a;
	IUTEST_ASSERT_THROW(exception_test(a), std::exception);
}

#endif

#endif

/**
 * ^teXg
*/
#if IUTEST_HAS_TYPED_TEST

template<typename T>
class TypedTest : public iutest::Test {};
typedef iutest::Types<int, long, short> TypedTestTypes;
IUTEST_TYPED_TEST_CASE(TypedTest, TypedTestTypes);

IUTEST_TYPED_TEST(TypedTest, Equal)
{
	TypeParam a = 0;
	IUTEST_ASSERT_EQ(0, a);
}

IUTEST_TYPED_TEST(TypedTest, Litle)
{
	TypeParam a = 1;
	IUTEST_ASSERT_LT(0, a);
}

#endif

#if IUTEST_HAS_TYPED_TEST_P

template<typename T>
class TypedTestP : public iutest::Test {};
typedef iutest::Types<int, long, short> TypedTestTypes;
IUTEST_TYPED_TEST_CASE_P(TypedTestP);

IUTEST_TYPED_TEST_P(TypedTestP, Equal)
{
	TypeParam a = 0;
	IUTEST_ASSERT_EQ(0, a);
}

IUTEST_TYPED_TEST_P(TypedTestP, Litle)
{
	TypeParam a = 1;
	IUTEST_ASSERT_LT(0, a);
}

IUTEST_REGISTER_TYPED_TEST_CASE_P(TypedTestP, Equal, Litle);
IUTEST_INSTANTIATE_TYPED_TEST_CASE_P(TypedTestPInstance, TypedTestP, TypedTestTypes);

#endif

#if defined(IUTEST_OS_WINDOWS)

IUTEST(TestHResult, True)
{
	IUTEST_ASSERT_HRESULT_SUCCEEDED(0);
}

IUTEST(TestHResult, False)
{
	IUTEST_ASSERT_HRESULT_FAILED(-1);
}

#endif


/**
 * s̊mF
*/
#if defined(SHOW_FAILURE)	// Failure Test

IUTEST(TestFailure, EQ)
{
	IUTEST_ASSERT_EQ(0, 1);
}

IUTEST(TestFailure, NE)
{
	int x=1, y=1;
	IUTEST_ASSERT_NE(x, y);
}

IUTEST(TestFailure, GE)
{
	float a = 0.1f, b = 1.0f;
	IUTEST_ASSERT_GE(a, b);
}

IUTEST(TestFailure, TRUE)
{
	IUTEST_ASSERT_TRUE(0);
	IUTEST_ASSERT_TRUE(false);
}

IUTEST(TestFailure, FALSE)
{
	IUTEST_ASSERT_FALSE(true);
	IUTEST_ASSERT_FALSE(2);
}

IUTEST(TestFailure, Fail)
{
	IUTEST_FAIL() << "add messages.\n";
}

#if defined(IUTEST_OS_WINDOWS)

IUTEST(TestFailure, HRESULT)
{
	IUTEST_ASSERT_HRESULT_SUCCEEDED(E_OUTOFMEMORY);
}

#endif


#if IUTEST_HAS_GENRAND

IUTEST(TestExpectFailure, Random)
{
	IUTEST_EXPECT_EQ( genrand(), genrand() );
	IUTEST_EXPECT_EQ( genrand(), genrand() );
	IUTEST_EXPECT_EQ( genrand(), genrand() );
	IUTEST_EXPECT_EQ( genrand(), genrand() );
	IUTEST_EXPECT_EQ( genrand(), genrand() );
	IUTEST_EXPECT_EQ( genrand(), genrand() );
}

#endif

IUTEST(TestExpectFailure, Pred)
{
	int x=4, y=5;
	IUTEST_EXPECT_PRED1(IsOdd, x);
	IUTEST_EXPECT_PRED2(IsGreater, x, y);
}

IUTEST(TestExpectFailure, OREQ)
{
	IUTEST_EXPECT_PRED_FORMAT2(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 0);
	IUTEST_EXPECT_PRED_FORMAT3(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 1, 0);
	IUTEST_EXPECT_PRED_FORMAT3(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 0, 1);
	IUTEST_EXPECT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 2, 1, 0);
	IUTEST_EXPECT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 0, 2, 1);
	IUTEST_EXPECT_PRED_FORMAT4(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 2, 0, 1);
	IUTEST_EXPECT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 3, 2, 1, 0);
	IUTEST_EXPECT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 0, 3, 2, 1);
	IUTEST_EXPECT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 3, 0, 2, 1);
	IUTEST_EXPECT_PRED_FORMAT5(iuutil::CmpHelperOR<iuutil::CmpHelper::EQ>::Comp, 100, 3, 2, 0, 1);
}

#if IUTEST_HAS_EXCEPTIONS
IUTEST(TestExpectFailure, Exception)
{
	IUTEST_EXPECT_THROW(Exception(0), int);
	IUTEST_EXPECT_ANY_THROW(Exception(0));
	IUTEST_EXPECT_NO_THROW(Exception(2));
}
IUTEST(TestExpectFailure, UnexpectedException1)
{
	throw "fail";
}
IUTEST(TestExpectFailure, UnexpectedException2)
{
	strcpy(NULL, NULL);
}
#endif

IUTEST(TestExpectFailure, Mix)
{
	IUTEST_EXPECT_EQ(0.1, 1);
	IUTEST_EXPECT_NE(0, 0);
	IUTEST_EXPECT_LE(2, 0);
	IUTEST_EXPECT_LT(0, 0);
	IUTEST_EXPECT_GE(0, 2);
	IUTEST_EXPECT_GT(0, 0);
	IUTEST_EXPECT_TRUE(0);
	IUTEST_EXPECT_FALSE(1);
	IUTEST_EXPECT_FLOAT_EQ(0.0f, 0.1f);
	IUTEST_EXPECT_DOUBLE_EQ(0.0, 0.1);
	IUTEST_EXPECT_NEAR(0, 100, 2);
	IUTEST_EXPECT_FAIL();
}

// Tu[`
static void Sub1(int n)
{
	IUTEST_EXPECT_EQ(1, n);
}
static void Sub2(int n)
{
	IUTEST_ASSERT_EQ(1, n);
}
IUTEST(TestFailureSubroutine, Test1)
{
	{
		IUTEST_SCOPED_MESSAGE("routine1.");

		Sub1(2);
	}
	// ̎sɂ "routine1." ̃bZ[W͕\܂B
	Sub1(3);
}

IUTEST(TestFailureSubroutine, Test2)
{
	{
		IUTEST_SCOPED_MESSAGE("routine2.");

		Sub2(2);
	}
	// ̎sɂ "routine2." ̃bZ[W͕\܂B
	Sub2(3);
}

#endif


