//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		hello_world.cpp
 * @brief		hello_world t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include "iris_using.h"
#include <algorithm>

namespace hello_world
{

int32_t FortyTwo() {
  return 42;
}

std::string ReverseText(const std::string& text) {
  std::string reversed_string(text);
  // Use reverse to reverse |reversed_string| in place.
  std::reverse(reversed_string.begin(), reversed_string.end());
  return reversed_string;
}


/// method name for ReverseText, as seen by JavaScript code.
const char* const kReverseTextMethodId = "reverseText";

/// method name for FortyTwo, as seen by Javascript code. @see FortyTwo()
const char* const kFortyTwoMethodId = "fortyTwo";

class HelloWorldInstance : public CInstance<HelloWorldInstance>
{
	typedef CInstance<HelloWorldInstance>	_Mybase;
public:
	HelloWorldInstance(PP_Instance instance)
		: _Mybase(instance)
	{
		AddMethod(kReverseTextMethodId, CMethodFactory::CreateMethod(ReverseText));
		AddMethod(kFortyTwoMethodId, CMethodFactory::CreateMethod(FortyTwo));
	}
};

}

namespace pp
{

Module* CreateModule() 
{
	typedef iris::nacl::CModule<hello_world::HelloWorldInstance>	Module;
	return Module::CreateInstance();
}

}
