//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		hash.cpp
 * @brief		hash t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "web/nacl/core/NaclModule.h"
#include "web/nacl/object/NaclScriptableObj.h"
#include <algorithm>
#include "iris_using.h"

#include "fnd/hash/FndMD5.h"

namespace hash
{

std::string calcHash(const std::string& text)
{
	char str[256];
	iris::fnd::CMD5 hash(text.data(), text.size());
	hash.ToStringA(str, sizeof(str));
	return str;
}

std::string selectFile()
{
	return "selectFile";
}

class HashTestInstance : public CInstance<HashTestInstance>
{
	typedef CInstance<HashTestInstance>	_Mybase;
public:
	HashTestInstance(PP_Instance instance)
		: _Mybase(instance)
	{
		printf("Initialize HashScriptableObject.\n");
		AddMethod("calcHash", CMethodFactory::CreateMethod(calcHash));
		AddMethod("selectFile", CMethodFactory::CreateMethod(selectFile));
	}
};

}

// Gg|Cg̋Lq
typedef iris::nacl::CModule<hash::HashTestInstance>	Module;
static iris::nacl::CModuleEntry<Module> s_module_entry;

#if 1
namespace pp
{

Module* CreateModule() 
{
	if( iris::nacl::IModuleEntry::GetInstancePtr() == nullptr ) return nullptr;
	return iris::nacl::IModuleEntry::GetInstance().CreateInstance();
}

}
#endif
