//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_quaternion.cpp
 * @brief		MathTQuaternion eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_quaternion_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTQuaternion.h"
#include "iris_using.h"

TEST(MathTQuaternionTest, Unit)
{
#define UNITTEST(type, zero, one)		do {\
		typedef IrisTQuaternion<type> quaternion;	\
		quaternion quat;							\
		TFpuQuaternionUnit(&quat);			\
		ASSERT_EQ( zero, quat.x );			\
		ASSERT_EQ( zero, quat.y );			\
		ASSERT_EQ( zero, quat.z );			\
		ASSERT_EQ( one , quat.w );			\
	} while(0)

	UNITTEST(int	,   0,   1);
	UNITTEST(float	, 0.f, 1.f);
	UNITTEST(double	, 0.0, 1.0);
}
