//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_plane.cpp
 * @brief		MathTPlane eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_plane_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTPlane.h"
#include "iris_using.h"

TEST(MathTPlaneTest, Set)
{
#define SETTEST(type, _a, _b, _c, _d)	do {\
		typedef IrisTPlane<type> plane;		\
		plane pln;							\
		TFpuPlaneSet(&pln, _a, _b, _c, _d);	\
		ASSERT_EQ( _a, pln.a );				\
		ASSERT_EQ( _b, pln.b );				\
		ASSERT_EQ( _c, pln.c );				\
		ASSERT_EQ( _d, pln.d );				\
	} while(0)

	SETTEST(int		, 0, 1, 2, 3);
	SETTEST(float	, 0.f, 1.f, 2.f, 3.f);
	SETTEST(double	, 0.0, 0.1, 0.2, 0.3);
}
