//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_tfpu_mtx44.cpp
 * @brief		MathTMatrix44 eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_tfpu_mtx44_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "math/tfpu/MathTMatrix44.h"
#include "iris_using.h"

TEST(MathTMatrix44Test, Zero)
{
#define ZEROTEST(type, zero)	do {	\
		typedef IrisTMtx44<type> mtx44;	\
		mtx44 mtx;						\
		TFpuMtx44Zero(&mtx);			\
		ASSERT_EQ( zero, mtx.x.x );		\
		ASSERT_EQ( zero, mtx.x.y );		\
		ASSERT_EQ( zero, mtx.x.z );		\
		ASSERT_EQ( zero, mtx.x.w );		\
		ASSERT_EQ( zero, mtx.y.x );		\
		ASSERT_EQ( zero, mtx.y.y );		\
		ASSERT_EQ( zero, mtx.y.z );		\
		ASSERT_EQ( zero, mtx.y.w );		\
		ASSERT_EQ( zero, mtx.z.x );		\
		ASSERT_EQ( zero, mtx.z.y );		\
		ASSERT_EQ( zero, mtx.z.z );		\
		ASSERT_EQ( zero, mtx.z.w );		\
		ASSERT_EQ( zero, mtx.w.x );		\
		ASSERT_EQ( zero, mtx.w.y );		\
		ASSERT_EQ( zero, mtx.w.z );		\
		ASSERT_EQ( zero, mtx.w.w );		\
	} while(0)

	ZEROTEST(int	, 0);
	ZEROTEST(float	, 0.f);
	ZEROTEST(double	, 0.0);
}
