//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_iml_math.cpp
 * @brief		iml_math.hpp eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_iml_math_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "ml/iml_math.hpp"
#include "iris_using.h"

TEST(iml_mathTest, gcd)
{
	ASSERT_EQ( -2, (iml::static_gcd<-2, 200>::value) );
	ASSERT_EQ(  2, (iml::static_gcd< 2, 200>::value) );
	ASSERT_EQ(  1, (iml::static_gcd< 5, 17>::value) );
}

TEST(iml_mathTest, lcm)
{
	ASSERT_EQ( 200, (iml::static_lcm<2, 200>::value) );
	ASSERT_EQ(  85, (iml::static_lcm<5, 17>::value) );
}

TEST(iml_mathTest, pow)
{
	ASSERT_EQ(  4, (iml::static_pow<-2, 2>::value) );
	ASSERT_EQ( 16, (iml::static_pow< 2, 4>::value) );
	ASSERT_EQ( 81, (iml::static_pow< 3, 4>::value) );
	ASSERT_EQ(  1, (iml::static_pow< 9, 0>::value) );
	ASSERT_EQ(  0, (iml::static_pow< 0,10>::value) );
}

TEST(iml_mathTest, is_pow2)
{
	ASSERT_TRUE( iml::static_is_pow2<1>::value );
	ASSERT_TRUE( iml::static_is_pow2<2>::value );
	ASSERT_TRUE( iml::static_is_pow2<256>::value );
	ASSERT_TRUE( iml::static_is_pow2<1024>::value );
	ASSERT_TRUE( iml::static_is_pow2<4096>::value );

	ASSERT_FALSE( iml::static_is_pow2<0>::value );
	ASSERT_FALSE( iml::static_is_pow2<3>::value );
	ASSERT_FALSE( iml::static_is_pow2<0xFFFF>::value );
}

TEST(iml_mathTest, log2)
{
	ASSERT_EQ( 0, iml::static_log2<1>::value );
	ASSERT_EQ( 5, iml::static_log2<32>::value );
	ASSERT_EQ( 16, iml::static_log2<0x10000>::value );
}

TEST(iml_mathTest, signed_lshift)
{
	ASSERT_EQ(  4, iml::signed_lshift< 1>::shift(2) );
	ASSERT_EQ(  1, iml::signed_lshift<-1>::shift(2) );
	ASSERT_EQ( 16, iml::signed_lshift< 4>::shift(1) );
	ASSERT_EQ(  0, iml::signed_lshift<-8>::shift<u8>(1) );
}

TEST(iml_mathTest, signed_rshift)
{
	ASSERT_EQ(  4, iml::signed_rshift<-1>::shift(2) );
	ASSERT_EQ(  1, iml::signed_rshift< 1>::shift(2) );
	ASSERT_EQ( 16, iml::signed_rshift<-4>::shift(1) );
	ASSERT_EQ(  0, iml::signed_rshift< 8>::shift<u8>(1) );
}
