//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_encoding.cpp
 * @brief		FndEncoding eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_encoding_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/charcode/FndEncoding.h"
#include "fnd/charcode/FndUTF8.h"
#include "fnd/charcode/FndASCII.h"
#include "iris_using.h"

const u16 utf16_buf[] = {
#include "utf16.inc"
};

class UTF16LETest : public ::testing::TestWithParam<int>{
};
INSTANTIATE_TEST_CASE_P(ParamTest, UTF16LETest, ::testing::Range<int>(0, (sizeof(utf16_buf)*3/8)) );

TEST_P(UTF16LETest, Encoding)
{
	int ofs = GetParam();
	ASSERT_EQ( iris::fnd::CEncoding::GetEncoding(utf16_buf+ofs, sizeof(utf16_buf) - ofs*2), iris::fnd::ENC_CP_UTF16LE );
}

const u16 utf16be_buf[] = {
#include "utf16be.inc"
};

class UTF16BETest : public ::testing::TestWithParam<int>{
};
INSTANTIATE_TEST_CASE_P(ParamTest, UTF16BETest, ::testing::Range<int>(0, (sizeof(utf16be_buf)*3/8)) );

TEST_P(UTF16BETest, Encoding)
{
	int ofs = GetParam();
	ASSERT_EQ( iris::fnd::CEncoding::GetEncoding(utf16be_buf+ofs, sizeof(utf16be_buf) - ofs*2), iris::fnd::ENC_CP_UTF16BE );
}

#if 1
const u8 utf8_buf[] = {
#include "utf8.inc"
};

class UTF8Test : public ::testing::TestWithParam<int>{
};
INSTANTIATE_TEST_CASE_P(ParamTest, UTF8Test, ::testing::Range<int>(0, (sizeof(utf8_buf)*3/4)) );

TEST_P(UTF8Test, Encoding)
{
	int ofs = GetParam();
	iris::fnd::CODEPAGE cp = iris::fnd::CEncoding::GetEncoding(utf8_buf+ofs, sizeof(utf8_buf) - ofs);
	ASSERT_EQ( cp, iris::fnd::ENC_CP_UTF8 );
}
#endif




