//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_rbtree.cpp
 * @brief		FndRedBlackTree eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_bstree_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/tree/FndRedBlackTree.h"
#include "iris_using.h"

typedef CRBTreeNode<int>	Node;
typedef CRBTree<Node>		Tree;

#define LOOP_NUM	100

TEST(FndRedBlackTreeTest, ConstTest)
{
	Tree tree;
	int v[] =
	{
0x2864,
0xdb4,
0xd4d,
0x3a17,
0x4269,
0x915,
0x331a,
0x2422,
0x836,
0x6922,
0x46d2,
0x7495,
0x7e43,
0x3207,
0x4747,
0x4d11,
0x2581,
0x6f7a,
0x259e,
0x5d33,
0x25e3,
0x4539,
0x63f6,
0x21d,
0x63b4,
0x74b,
0x67a5,
0x38ac,
0x3506,
0x6099,
0x6f28,
0x7616,
0x562a,
0x7144,
0x6023,
0x306c,
0x6eb7,
0x662,
0x242c,
0x471d,
0x294b,
0x21ea,
0x1a03,
0xd8b,
0x5a6b,
0xc8d,
0x3e53,
0x5931,
0x1df7,
0x5dbb,
0x4999,
0x442a,
0x1ae5,
0x9b,
0x1a34,
0x13ec,
0x1f2e,
0x705a,
0x4f69,
0x7832,
0x32e8,
0xec4,
0x15aa,
0x363a,
0x66af,
0x4911,
0x1431,
0x614a,
0x7f01,
0x4b46,
0x18ec,
0x602b,
0x4540,
0x73d8,
0x2177,
0x3391,
0x16cc,
0x2134,
0x23a8,
0x3d79,
0x39ef,
0x1e7d,
0x7bef,
0x3778,
0x69b3,
0x432a,
0x4a3d,
0xed0,
0x3728,
0x119a,
0x26c3,
0x5cfc,
0x6fa9,
0x144b,
0x5a58,
0x4e88,
0x3860,
0x1b4c,
0x761b,
0x6c26,
0x30d,
0x6df5,
0xe5a,
0x79ff,
0x4002,
0x44d5,
0x1cb3,
0x6147,
0x7172,
0x1fec,
0x4d79,
0x5814,
0x3ec,
0x4d1a,
0x3c5a,
0x3b70,
0x1023,
0x32d8,
0x643e,
0x4fac,
0x69f0,
0x3326,
0x4671,
0x5af8,
0x209a,
0x3ac4,
0xd05,
0x4e31,
0x50a5,
0x2c72,
0x6ffa,
0x507,
0x39a1,
0x4880,
0x3e0e,
0x3e52,
0x46a,
0x6067,
0x78d5,
0x44d0,
0x11c1,
0x634,
0xd35,
0x2899,
0x6cea,
0x256e,
0x50aa,
0x610b,
0x85d,
0x1cfa,
0x4399,
0x55ca,
0x32be,
0x303c,
0x4de1,
0x7905,
0x580f,
0x137f,
0x29b4,
0x56fb,
0x6325,
0x1797,
0x70a5,
0x3ebe,
0x5358,
0x38c4,
0x7f01,
0x6837,
0x5a7f,
0x14da,
0x2163,
0x171c,
0xc9f,
0x4083,
0x1cfc,
0x3ed3,
0x1475,
0x7f4f,
0x63f3,
0x4d21,
0x7839,
0x7f3d,
0x5cbc,
0xa4a,
0x166a,
0x3edf,
0x7d72,
0x7e93,
0x568e,
0x46b8,
0x2f5e,
0x25b2,
0x5ed1,
0x184e,
0x51ba,
0x7683,
0x4cf0,
0x1380,
0x59ba,
0x12fc,
0x7655,
0x33cd,
0x3463,
0x7384,
0x59a7,
0x4a20,
0x27be,
0x7ab5,
0x1386,
0x5463,
0x6e8c,
0x4dc2,
0x1b40,
0x54d1,
0x57b2,
0x3f44,
0x7b19,
0x666a,
0x24b8,
0x12f9,
0xee5,
0x4083,
0xf35,
0x3d6a,
0x551d,
0x1381,
0x4288,
0x46ca,
0x5632,
0x22e2,
0x1dc9,
0x5520,
0x1621,
0x407d,
0x5200,
0x21a9,
0x4448,
0x3094,
0x5d77,
0x1d78,
0x21e4,
0x3e06,
0x495f,
0x344b,
0x5cde,
0x512,
0x13b8,
0x2074,
0x24e6,
0x6fe4,
0x6174,
0x3a97,
0x2a8,
0x593b,
0xd9d,
0x3ad1,
0x3c1b,
0x25c0,
0x47b7,
0xecf,
0x1583,
0x4a1,
0x2803,
0x3c59,
0x51d6,
0x700f,
0x36c4,
0x63b,
0x5603,
0x714c,
0x6ffd,
0x70f7,
0x6ad6,
0x6b06,
0x347d,
0x7fb7,
0x561c,
0x5de3,
0x4c19,
0x3d85,
0xf07,
0x5b5d,
0x5d39,
0x66be,
0x11d4,
0x1ad0,
0x7d96,
0x46c4,
0x16aa,
0x64d1,
0x4041,
0x1df4,
0x2fc6,
0x48c2,
	};
	Node node[IRIS_NumOfElements(v)];
	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		node[i] = v[i];
	}

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		tree.insert(node+i);
	}

	Tree::iterator it = tree.begin();
	ASSERT_EQ( TRUE, it != tree.null_node() );
	ASSERT_EQ( TRUE, it != tree.end() );

	int pre = *(*it++);
	for( int i=1; i < IRIS_NumOfElements(node); ++i, ++it )
	{
		int tmp = *(*it);
		ASSERT_LE( pre, tmp );
	}

	it = tree.back();
	pre = *(*it--);
	for( int i=1; i < IRIS_NumOfElements(node); ++i, --it )
	{
		int tmp = *(*it);
		ASSERT_GE( pre, tmp );
	}

	while( !tree.empty() )
	{
		int num = tree.count() / 2;
		it = tree.begin();
		for( int i=0; i < num; ++i ) ++it;
		tree.erase(it);
	}
	tree.clear();
	ASSERT_TRUE(tree.empty());
}

TEST(FndRedBlackTreeTest, RandomTest)
{
	Tree tree;

	for( int n=0; n < LOOP_NUM; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = rand();
		}

		for( int i=0; i < num; ++i )
		{
			//printf("0x%x,\n", *node[i]);
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		tree.clear();
		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}


TEST(FndRedBlackTreeTest, RandomErase)
{
	Tree tree;

	for( int n=0; n < LOOP_NUM; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = rand();
		}

		for( int i=0; i < num; ++i )
		{
			//printf("0x%x,\n", v[i]);
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		while( !tree.empty() )
		{
			int num = ((rand() & 0x7FFF) >> 9) + 1;
			num %= tree.count();
			it = tree.begin();
			for( int i=0; i < num; ++i ) ++it;
			tree.erase(it);
		}

		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}

TEST(FndRedBlackTreeTest, SameKeyTest)
{
	Tree tree;

	for( int n=0; n < 100; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		int v = rand();
		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = v;
		}

		for( int i=0; i < num; ++i )
		{
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		tree.clear();
		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}
