//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_operator.cpp
 * @brief		FndOperator eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_operator_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndOperators.h"
#include "iris_using.h"
#include "iris_debug.h"

#include "c++0x/cpp0x_type_traits.hpp"

// FndOperator eXg
// opposite
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp, CFalseOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp, CTrueOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp, CNotEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp, CGEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp, CGreaterOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp, CLEqualOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp, CLessOp::opposite>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp, CEqualOp::opposite>::value) );

// append
// CFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CEqualOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CLessOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CLEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CGreaterOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CGEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::append<CNotEqualOp>::type, CNotEqualOp>::value) );

// CTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CEqualOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CLessOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CLEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CGreaterOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CGEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::append<CNotEqualOp>::type, CNotEqualOp>::value) );

// CEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CEqualOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CLessOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CLEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CGreaterOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CGEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::append<CNotEqualOp>::type, CTrueOp>::value) );

// CLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CLessOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CLEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CGreaterOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CGEqualOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::append<CNotEqualOp>::type, CLessOp>::value) );

// CLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CLessOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CLEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CGreaterOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CGEqualOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::append<CNotEqualOp>::type, CLessOp>::value) );

// CGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CLessOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CLEqualOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CGreaterOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CGEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::append<CNotEqualOp>::type, CGreaterOp>::value) );

// CGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CLessOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CLEqualOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CGreaterOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CGEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::append<CNotEqualOp>::type, CGreaterOp>::value) );

// CNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CTrueOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CEqualOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CLessOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CLEqualOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CGreaterOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CGEqualOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::append<CNotEqualOp>::type, CNotEqualOp>::value) );

// erase
// CFalseOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CFalseOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CLessOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CLEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CGreaterOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CGEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CFalseOp::erase<CNotEqualOp>::type, CFalseOp>::value) );

// CTrueOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CFalseOp>::type, CTrueOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CEqualOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CLessOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CLEqualOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CGreaterOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CGEqualOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CTrueOp::erase<CNotEqualOp>::type, CEqualOp>::value) );

// CEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CFalseOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CLessOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CLEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CGreaterOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CGEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CEqualOp::erase<CNotEqualOp>::type, CEqualOp>::value) );

// CLessOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CFalseOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CEqualOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CLessOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CLEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CGreaterOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CGEqualOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLessOp::erase<CNotEqualOp>::type, CLEqualOp>::value) );

// CLEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CFalseOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CEqualOp>::type, CLessOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CLessOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CLEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CGreaterOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CGEqualOp>::type, CLEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CLEqualOp::erase<CNotEqualOp>::type, CLEqualOp>::value) );

// CGreaterOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CFalseOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CEqualOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CLessOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CLEqualOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CGreaterOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CGEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGreaterOp::erase<CNotEqualOp>::type, CGEqualOp>::value) );

// CGEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CFalseOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CEqualOp>::type, CGreaterOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CLessOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CLEqualOp>::type, CGEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CGreaterOp>::type, CEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CGEqualOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CGEqualOp::erase<CNotEqualOp>::type, CGEqualOp>::value) );

// CNotEqualOp
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CFalseOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CTrueOp>::type, CFalseOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CEqualOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CLessOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CLEqualOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CGreaterOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CGEqualOp>::type, CNotEqualOp>::value) );
IRIS_STATIC_ASSERT( (cpp0x::is_same<CNotEqualOp::erase<CNotEqualOp>::type, CFalseOp>::value) );

//======================================================================
// test
TEST(FndOperatorTest, Func)
{
	ASSERT_TRUE( !CFalseOp()(0, 0) ); 
	ASSERT_TRUE( !CFalseOp()(1, 0) );
	ASSERT_TRUE( !CFalseOp()(0, 1) );

	ASSERT_TRUE(  CTrueOp()(0, 0) );
	ASSERT_TRUE(  CTrueOp()(1, 0) );
	ASSERT_TRUE(  CTrueOp()(0, 1) );

	ASSERT_TRUE(  CEqualOp()(0, 0) );
	ASSERT_TRUE( !CEqualOp()(1, 0) );
	ASSERT_TRUE( !CEqualOp()(0, 1) );

	ASSERT_TRUE( !CLessOp()(0, 0) );
	ASSERT_TRUE( !CLessOp()(1, 0) );
	ASSERT_TRUE(  CLessOp()(0, 1) );

	ASSERT_TRUE(  CLEqualOp()(0, 0) );
	ASSERT_TRUE( !CLEqualOp()(1, 0) );
	ASSERT_TRUE(  CLEqualOp()(0, 1) );

	ASSERT_TRUE( !CGreaterOp()(0, 0) );
	ASSERT_TRUE(  CGreaterOp()(1, 0) );
	ASSERT_TRUE( !CGreaterOp()(0, 1) );

	ASSERT_TRUE(  CGEqualOp()(0, 0) );
	ASSERT_TRUE(  CGEqualOp()(1, 0) );
	ASSERT_TRUE( !CGEqualOp()(0, 1) );

	ASSERT_TRUE( !CNotEqualOp()(0, 0) );
	ASSERT_TRUE(  CNotEqualOp()(1, 0) );
	ASSERT_TRUE(  CNotEqualOp()(0, 1) );
}

