//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_avltree.cpp
 * @brief		FndAVLTree eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_avltree_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/tree/FndAVLTree.h"
#include "iris_using.h"

typedef CAVLTreeNode<int>	Node;
typedef CAVLTree<Node>		Tree;

#define LOOP_NUM	100

TEST(FndAVLTreeTest, Func)
{
	Tree tree;
	int v[] =
	{
		0x2bdd,
		0x46b1,
		0x1dff,
		0x436a,
		0x2918,
		0x2e6c,
		0x12c4,
		0x275,
		0x3028,
		0x77e7,
		0x1895,
		0x4f81,
		0x1dc7,
		0x6003,
		0x3f97,
		0x65ae,
		0x3de6,
		0x4afa,
		0x42f4,
		0x1c0f,
		0x3196,
	};
	Node node[IRIS_NumOfElements(v)];
	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		node[i] = v[i];
	}

	for( int i=0; i < IRIS_NumOfElements(node); ++i )
	{
		tree.insert(node+i);
	}

	Tree::iterator it = tree.begin();
	ASSERT_EQ( TRUE, it != tree.null_node() );
	ASSERT_EQ( TRUE, it != tree.end() );

	int pre = *(*it++);
	for( int i=1; i < IRIS_NumOfElements(node); ++i, ++it )
	{
		int tmp = *(*it);
		ASSERT_LE( pre, tmp );
	}

	it = tree.back();
	pre = *(*it--);
	for( int i=1; i < IRIS_NumOfElements(node); ++i, --it )
	{
		int tmp = *(*it);
		ASSERT_GE( pre, tmp );
	}

	tree.clear();
	ASSERT_TRUE(tree.empty());
}

TEST(FndAVLTreeTest, RandomTest)
{
	Tree tree;

	for( int n=0; n < LOOP_NUM; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = rand();
		}

		for( int i=0; i < num; ++i )
		{
			//printf("0x%x,\n", v[i]);
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		tree.clear();

		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}

NO_TEST(FndAVLTreeTest, RandomErase)
{
	Tree tree;

	for( int n=0; n < LOOP_NUM; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = rand();
		}

		for( int i=0; i < num; ++i )
		{
			//printf("0x%x,\n", v[i]);
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		while( !tree.empty() )
		{
			int num = ((rand() & 0x7FFF) >> 9) + 1;
			num %= tree.count();
			it = tree.begin();
			for( int i=0; i < num; ++i ) ++it;
			tree.erase(it);
		}

		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}

TEST(FndAVLTreeTest, SameKeyTest)
{
	Tree tree;

	for( int n=0; n < 100; ++n )
	{
		ASSERT_TRUE( tree.empty() );

		int num = ((rand() & 0x7FFF) >> 9) + 1;

		int v = rand();
		Node* node = new Node [num];
		for( int i=0; i < num; ++i )
		{
			node[i] = v;
		}

		for( int i=0; i < num; ++i )
		{
			tree.insert(node+i);
		}
		ASSERT_EQ( num, tree.count() );

		Tree::iterator it = tree.begin();
		ASSERT_EQ( TRUE, it != tree.null_node() );
		ASSERT_EQ( TRUE, it != tree.end() );

		int pre = *(*it++);
		for( int i=1; i < num; ++i, ++it )
		{
			ASSERT_EQ( TRUE, it != Tree::iterator::null() );
			int tmp = *(*it);
			int dec = *(*--it);
			int inc = *(*++it);
			int tmp2 = tmp;
			ASSERT_LE( pre, tmp );
			ASSERT_EQ( pre, dec );
			ASSERT_EQ( inc, tmp );
			Node nd(tmp2);
			ASSERT_EQ( tmp, *(*tree.search(nd)));
			ASSERT_EQ( tmp, *(*tree.search_less(nd)));
			ASSERT_EQ( tmp, *(*tree.search_more(nd)));
			pre = tmp;
		}

		it = tree.back();
		pre = *(*it--);
		for( int i=1; i < num; ++i, --it )
		{
			int tmp = *(*it);
			ASSERT_GE( pre, tmp );
			pre = tmp;
		}

		tree.clear();

		ASSERT_TRUE(tree.empty());
		delete [] node;
	}
}
