//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_array.cpp
 * @brief		Fndarray eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_array_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "fnd/container/FndArray.h"
#include "iris_using.h"

typedef IrisFixedArray<int, 4>	FixedArray;
typedef CArray<int>				Array;

TEST(FndFixedArrayTest, Func)
{
	FixedArray fa = { 0, 1, 2, 3 };

	ASSERT_EQ( 0, fa[0] );
	ASSERT_EQ( 1, fa[1] );
	ASSERT_EQ( 2, fa[2] );
	ASSERT_EQ( 3, fa[3] );

	ASSERT_EQ( sizeof(int)*4, sizeof(fa));
}

TEST(FndArrayTest, Func)
{
	Array a(10);
	Array b;

	ASSERT_EQ(10, a.size() );

	for( u32 i=0; i < a.size(); ++i )
	{
		a[i] = i;
	}

	for( u32 i=0; i < a.size(); ++i )
	{
		ASSERT_EQ( i, a.at(i) );
	}

	b = a;
	ASSERT_EQ(10, b.size() );
	for( u32 i=0; i < b.size(); ++i )
	{
		ASSERT_EQ( i, b.at(i) );
	}

	b.resize(2);
	ASSERT_EQ(2, b.size() );
	for( u32 i=0; i < b.size(); ++i )
	{
		ASSERT_EQ( i, b.at(i) );
	}
}
