//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_typetraits.cpp
 * @brief		typetraits eXg t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_typetraits_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "c++0x/cpp0x_type_traits.hpp"
#include "iris_using.h"

#define IS_TRAITES_TEST( _name, _type, _result)						\
	ASSERT_##_result( cpp0x::_name<_type>::value );					\
	ASSERT_##_result( cpp0x::_name<const _type>::value );			\
	ASSERT_##_result( cpp0x::_name<volatile _type>::value );		\
	ASSERT_##_result( cpp0x::_name<volatile const _type>::value );	\
	ASSERT_##_result( cpp0x::_name<far _type>::value );				\
	ASSERT_##_result( cpp0x::_name<near _type>::value );			\
	ASSERT_##_result( cpp0x::_name<register _type>::value )			\

TEST(TypeTraitsTest, is_pointer)
{
	IS_TRAITES_TEST(is_pointer, int , FALSE);
	IS_TRAITES_TEST(is_pointer, int*, TRUE);
	IS_TRAITES_TEST(is_pointer, int&, FALSE);
}

TEST(TypeTraitsTest, is_reference)
{
	IS_TRAITES_TEST(is_reference, int , FALSE);
	IS_TRAITES_TEST(is_reference, int*, FALSE);
	IS_TRAITES_TEST(is_reference, int&, TRUE);
}

TEST(TypeTraitsTest, is_floating_point)
{
	IS_TRAITES_TEST(is_floating_point, int , FALSE);
	IS_TRAITES_TEST(is_floating_point, int*, FALSE);
	IS_TRAITES_TEST(is_floating_point, int&, FALSE);
	IS_TRAITES_TEST(is_floating_point, f32 , TRUE);
	IS_TRAITES_TEST(is_floating_point, f32&, FALSE);
	IS_TRAITES_TEST(is_floating_point, f32*, FALSE);
	IS_TRAITES_TEST(is_floating_point, f64 , TRUE);
	IS_TRAITES_TEST(is_floating_point, f64&, FALSE);
	IS_TRAITES_TEST(is_floating_point, f64*, FALSE);
	IS_TRAITES_TEST(is_floating_point, long double , TRUE);
	IS_TRAITES_TEST(is_floating_point, long double&, FALSE);
	IS_TRAITES_TEST(is_floating_point, long double*, FALSE);
}

TEST(TypeTraitsTest, is_char)
{
	IS_TRAITES_TEST(is_char, char , TRUE);
	IS_TRAITES_TEST(is_char, c8   , TRUE);
	IS_TRAITES_TEST(is_char, s8   , FALSE);
	IS_TRAITES_TEST(is_char, u8   , FALSE);
}

TEST(TypeTraitsTest, is_s_char)
{
	IS_TRAITES_TEST(is_s_char, signed char , TRUE);
	IS_TRAITES_TEST(is_s_char, c8   , FALSE);
	IS_TRAITES_TEST(is_s_char, s8   , TRUE);
	IS_TRAITES_TEST(is_s_char, u8   , FALSE);
}

TEST(TypeTraitsTest, is_u_char)
{
	IS_TRAITES_TEST(is_u_char, unsigned char , TRUE);
	IS_TRAITES_TEST(is_u_char, c8   , FALSE);
	IS_TRAITES_TEST(is_u_char, s8   , FALSE);
	IS_TRAITES_TEST(is_u_char, u8   , TRUE);
}

TEST(TypeTraitsTest, is_char_traits)
{
	IS_TRAITES_TEST(is_char_traits, char , TRUE);
	IS_TRAITES_TEST(is_char_traits, c8   , TRUE);
	IS_TRAITES_TEST(is_char_traits, s8   , TRUE);
	IS_TRAITES_TEST(is_char_traits, u8   , TRUE);
}

TEST(TypeTaritsTest, is_scalar)
{
	ASSERT_TRUE ( cpp0x::is_scalar<void*>::value );
	ASSERT_TRUE ( cpp0x::is_scalar<float>::value );
	ASSERT_TRUE ( cpp0x::is_scalar<volatile const unsigned long long>::value );
	ASSERT_FALSE( cpp0x::is_scalar<::testing::Test>::value );
}

class CSample { void test(void); };

typedef int (*func0)(void);
typedef void (*func1)(void*);
typedef float (*func7)(int a1, float a2, double a3, long long int a4, char a5, unsigned char a6, unsigned int a7);
TEST(TypeTraitsTest, function_traits)
{
	ASSERT_EQ(0, cpp0x::function_traits<void (CSample::*)(void) >::arity);
	
	ASSERT_EQ(0, cpp0x::function_traits<func0>::arity);
	ASSERT_TRUE( (cpp0x::is_same<int, cpp0x::function_traits<func0>::result_type>::value) );

	ASSERT_EQ(1, cpp0x::function_traits<func1>::arity);
	ASSERT_TRUE( (cpp0x::is_same<void, cpp0x::function_traits<func1>::result_type>::value) );
	ASSERT_TRUE( (cpp0x::is_same<void*, cpp0x::function_traits<func1>::arg1_type>::value) );

	ASSERT_EQ(7, cpp0x::function_traits<func7>::arity);
	ASSERT_TRUE( (cpp0x::is_same<float, cpp0x::function_traits<func7>::result_type>::value) );
}

TEST(TypeTraitsTest, is_function)
{
	ASSERT_TRUE( (cpp0x::is_function<func0>::value) );
	ASSERT_TRUE( (cpp0x::is_function<func1>::value) );
	ASSERT_TRUE( (cpp0x::is_function<func7>::value) );
}

TEST(TypeTaritsTest, is_pod)
{
	ASSERT_FALSE( (cpp0x::is_pod<endian_base<s16>::type>::value) );
	ASSERT_TRUE( (cpp0x::is_pod<s32>::value) );
}

TEST(TypeTraitsTest, add_pointer)
{
	int a = 0;
	int& b = a;
	int* p = &a;

	cpp0x::add_pointer<int>::type pa = &a;
	cpp0x::add_pointer<int&>::type pb = &b;
	cpp0x::add_pointer<int*>::type pp = &p;
	cpp0x::add_pointer_once<int*>::type pa2 = &a;
	cpp0x::remove_pointer<int>::type  ta = a;
	cpp0x::remove_pointer<int*>::type va = a;
	cpp0x::remove_pointer<int&>::type ra = b;
	ta = 10;
	va = 10;
	ASSERT_NE( a , 10 );
	ra = 10;
	ASSERT_EQ( a , 10 );
}

TEST(TypeTraitsTest, add_reference)
{
	int a = 0;
	int& b = a;
	int* p = &a;

	int* tp = p;
	cpp0x::add_reference<int>::type ra = a;
	cpp0x::add_reference<int&>::type rb = b;
	cpp0x::add_reference<int*>::type rp = tp;
	cpp0x::remove_reference<int&>::type ta = ra;
	ra = 10;
	ASSERT_EQ( a, 10 );
	rb = 11;
	ASSERT_EQ( a, 11 );
	rp = 0;
	ASSERT_NE( tp, p );

	ta = 100;
	ASSERT_NE( a , 100 );
}

TEST(TypeTraitsTest, extent)
{
	ASSERT_EQ( (cpp0x::extent<int [2][3][4], 0>::value), 2 );
	ASSERT_EQ( (cpp0x::extent<int [2][3][4], 1>::value), 3 );
	ASSERT_EQ( (cpp0x::extent<int [2][3][4], 2>::value), 4 );
	ASSERT_EQ( (cpp0x::extent<int [2][3][4], 3>::value), 0 );
}

TEST(TypeTraitsTest, rank)
{
	ASSERT_EQ( (cpp0x::rank<int>::value), 0 );
	ASSERT_EQ( (cpp0x::rank<int [2][3][4]>::value), 3 );
}

TEST(TypeTraitsTest, alignment_of)
{
	struct x
	{
		char a, b;
		int c;
	};
	ASSERT_EQ( (cpp0x::alignment_of<char>::value), 1 );
	ASSERT_EQ( (cpp0x::alignment_of<int>::value), 4 );
	ASSERT_EQ( (cpp0x::alignment_of<float>::value), 4 );
	ASSERT_EQ( (cpp0x::alignment_of<double>::value), 8 );
	ASSERT_EQ( (cpp0x::alignment_of<int [2][3][4]>::value), 4 );
	ASSERT_EQ( (cpp0x::alignment_of<x>::value), 4 );
}


//======================================================================
// typedef
typedef struct tagPOD
{
	int a, b, c;
} POD;

class IAbstract
{
public:
	enum eTEST {
		TEST
	};
public:
	IAbstract(void)		{}
	~IAbstract(void)	{}

	virtual int	Func(void)	= 0;
};

//======================================================================
// static test
IRIS_STATIC_ASSERT( !cpp0x::is_pointer<int&>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_pointer<int*>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_member_pointer<::testing::Test*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_pointer<int ::testing::Test::*>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_reference<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_reference<int&>::value );

IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_reference<int>::type, int >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_reference<const int&>::type, const int >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_reference<char const&>::type, char const >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_reference<char const volatile&>::type, char const volatile >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_reference<char*&>::type, char* >::value ));

IRIS_STATIC_ASSERT( !cpp0x::is_volatile<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_volatile<volatile int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_volatile<volatile char*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_volatile<char* volatile>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_volatile<volatile char&>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_const<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<const int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_const<const char*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_const<char* const>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_const<const char&>::value );

IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<int>::type, int >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<const int>::type, int >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<const char*>::type, const char* >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<char* const>::type, char* >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<const char&>::type, const char& >::value ));
IRIS_STATIC_ASSERT( (cpp0x::is_same< typename cpp0x::remove_const<char& const>::type, char& >::value ));

IRIS_STATIC_ASSERT( !cpp0x::is_floating_point<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile long double>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_wchar_t<wchar_t>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_wchar_t<const volatile wchar_t>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_wchar_t<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_char<char>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char<const volatile char>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_char<IrisS8>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_char<IrisS8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_char<const volatile IrisS8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_char<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_char<IrisU8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_char<const volatile IrisU8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_char<char>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<char>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<IrisS8>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_char_traits<IrisU8>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_char_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_short<short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short<const volatile short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short<IrisS16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_short<IrisU16>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_short<IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_short<const volatile IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_short<short>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_short<IrisU16>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_short<IrisU16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_short<const volatile IrisU16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_short<short>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<short>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<IrisS16>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_short_traits<IrisU16>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_short_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_int<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int<const volatile int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int<signed int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_int<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_int<signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_int<const volatile signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_int<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_int<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_int<unsigned int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_int<const volatile unsigned int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_int<IrisU32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<signed int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_int_traits<unsigned int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_int_traits<IrisS32>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long<long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long<const volatile long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long<signed long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_long<signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long<const volatile signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long<long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_long<unsigned long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_long<const volatile unsigned long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<signed long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_traits<unsigned long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_traits<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_long<long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long<const volatile long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long<signed long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<const volatile signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_s_long_long<long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_s_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_u_long_long<unsigned long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_u_long_long<const volatile unsigned long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_u_long_long<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<signed long long>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_long_traits<unsigned long long>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_long_long_traits<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_float<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_float<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_float<const volatile float>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_double<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_double<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_double<const volatile double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_long_double<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_double<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_long_double<const volatile long double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_floating_point<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<long double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile float>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile double>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_floating_point<const volatile long double>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_array<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_array<int*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[]>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[2]>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_array<int[][2]>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_enum<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_enum<IAbstract::eTEST>::value );

IRIS_STATIC_ASSERT( !cpp0x::is_class<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_class<::testing::Test>::value );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_empty<int>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_empty<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_empty<::iris::IIrisObject>::value );
#endif

IRIS_STATIC_ASSERT( !(cpp0x::is_base_and_derived<::testing::Test, int>::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_base_and_derived<::testing::Test, ::iris::IIrisObject>::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_base_and_derived<::iris::IIrisObject, ::iris::unit::CRandom >::value) );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_polymorphic<int>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_polymorphic<::testing::Test>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_polymorphic<::iris::IIrisObject>::value );
#endif

IRIS_STATIC_ASSERT( !cpp0x::is_abstract<::iris::unit::CRandom>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_abstract<IAbstract>::value );

IRIS_STATIC_ASSERT(  cpp0x::is_function<int ::testing::Test::*(int, int, int)>::value );
IRIS_STATIC_ASSERT( !cpp0x::is_function<int (::testing::Test::*)()>::value );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS
IRIS_STATIC_ASSERT( !cpp0x::is_pod<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_pod<POD>::value );
#endif

IRIS_STATIC_ASSERT( !cpp0x::is_member_function_pointer<int ::testing::Test::*>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_function_pointer<int (::testing::Test::*)()>::value );
IRIS_STATIC_ASSERT(  cpp0x::is_member_function_pointer<int (::testing::Test::*)(int, int, int)>::value );

IRIS_STATIC_ASSERT(  (cpp0x::is_same< int, int >::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_same< int, float >::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_same< cpp0x::remove_extent<int [2][3][4]>::type, int [3][4] >::value) );
IRIS_STATIC_ASSERT( !(cpp0x::is_same< cpp0x::remove_extent<int [2][3][4]>::type, int [2][3] >::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_same< cpp0x::remove_all_extent<int [2][3][4]>::type, int >::value) );

IRIS_STATIC_ASSERT( !(cpp0x::is_convertible<::testing::Test, int>::value) );
IRIS_STATIC_ASSERT(  (cpp0x::is_convertible<float, int>::value) );

IRIS_STATIC_ASSERT(  (cpp0x::is_function<int (int, int, int)>::value) );

#ifdef IRIS_HAS_TYPE_TRAITS_INTRINSICS

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_constructor<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_constructor<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_constructor<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_copy<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_copy<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_copy<int>::value );

IRIS_STATIC_ASSERT( !cpp0x::has_trivial_assign<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_assign<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_assign<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<::testing::Test>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<POD>::value );
IRIS_STATIC_ASSERT(  cpp0x::has_trivial_destructor<int>::value );

IRIS_STATIC_ASSERT(  cpp0x::has_virtual_destructor<::testing::Test>::value );

#endif

