//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_wavfile.cpp
 * @brief		wavfile eXgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_test_wavfile_CPP_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "audio/format/riff/AXWavFile.h"
#include "iris_iostream.h"
#include "iris_global.h"
#include "iris_using.h"
#include <tchar.h>

TEST(WavfileTest, Open)
{
	CWavFile wavfile;
	CHAR fname[MAX_PATH] = "..\\..\\..\\..\\data\\snd\\sample.wav";
	ASSERT_TRUE( wavfile.OpenA(fname) );

	WAVEFORMATEX wfex;
	wfex.cbSize = sizeof(WAVEFORMATEX);
	ASSERT_TRUE( wavfile.GetWaveFormatEx(&wfex) );

	ASSERT_EQ( sizeof(WAVEFORMATEX), wfex.cbSize );
	ASSERT_EQ( 2, wfex.nChannels );
	ASSERT_EQ( 44100, wfex.nSamplesPerSec );
	ASSERT_EQ( 16, wfex.wBitsPerSample );
	ASSERT_EQ( 4, wfex.nBlockAlign );
	ASSERT_EQ( 4*44100, wfex.nAvgBytesPerSec );
	ASSERT_EQ( WAVE_FORMAT_PCM, wfex.wFormatTag );
}


