//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		hypot_test.cpp
 * @brief		hypot_test t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _FILE_hypot_test_CPP_

//======================================================================
// include
#include "test_helper.h"
#include "iris_math.h"
#include "iris_using.h"

#define IRIS_ALLEGREX(func)	iris_allegrex_##func

TEST(AllgrexTest, hypot)
{
	struct func
	{
		void operator ()(int r)
		{
			int a = (r & 0xFFFF0000) >> 16;
			int b = (r & 0x0000FFFF);
			ASSERT_FLOAT_EQ( hypotf((float)a, (float)b)						, IRIS_ALLEGREX(hypotf)((float)a, (float)b) );
			ASSERT_FLOAT_EQ( hypotf((float)a/RAND_MAX, (float)b/RAND_MAX)	, IRIS_ALLEGREX(hypotf)((float)a/RAND_MAX, (float)b/RAND_MAX) );
			ASSERT_FLOAT_EQ( hypotf(a*101.2f, b*101.2f)						, IRIS_ALLEGREX(hypotf)(a*101.2f, b*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}

#undef IRIS_ALLEGREX
#define IRIS_ALLEGREX(func)	func

TEST(AllgrexTest, crt_hypot)
{
	struct func
	{
		void operator ()(int r)
		{
			int a = (r & 0xFFFF0000) >> 16;
			int b = (r & 0x0000FFFF);
			ASSERT_FLOAT_EQ( hypotf((float)a, (float)b)						, IRIS_ALLEGREX(hypotf)((float)a, (float)b) );
			ASSERT_FLOAT_EQ( hypotf((float)a/RAND_MAX, (float)b/RAND_MAX)	, IRIS_ALLEGREX(hypotf)((float)a/RAND_MAX, (float)b/RAND_MAX) );
			ASSERT_FLOAT_EQ( hypotf(a*101.2f, b*101.2f)						, IRIS_ALLEGREX(hypotf)(a*101.2f, b*101.2f) );
		}
	};
	randamloop(TESTNUM, func());
}
