//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		test_helper.h
 * @brief		test_helper t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _FILE_test_helper_H_
#define _FILE_test_helper_H_

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "misc/iris_allegrex.h"

//======================================================================
// define
#ifdef NDEBUG
#  define TESTNUM	1000000
#else
#  define TESTNUM	10000
#endif

//======================================================================
// function
template<typename FUNC>
void	randamloop(int num, FUNC func)
{
	for( int i=0; i < num; ++i )
	{
		int r = rand();
		try
		{
			func(r);
		}
		catch(...)
		{
			ASSERT_TRUE(0);
		}
	}
}


#endif
