//==================================================
//
// WinMain.cpp
//
//==================================================
#include "platform/windows/d3dx/DXLib.h"

#include "platform/windows/win/debug/WXDebugLeakCheckMacro.h"
#include "platform/windows/win/wx.h"
#include "iris_main.h"
#include <string>

#if	!defined(IUTEST_ENABLE)

//**********************************************************************
// C[`
//**********************************************************************
int iris_main(void)
{
	// VXe
	iris::wx::WXInit();

	iris::dx::ReleaseDxLibAll();

	MessageBox(nullptr, IRIS_TEXT("WMobileSample"), nullptr, MB_OK);

	// VXe
	iris::wx::WXTerm();

	return 0;
}

#else

#include "iutest.h"

int iris_main(void)
{
	IUTEST_RUN_ALL_TESTS();
	return 0;
}

IUTEST(Test, Test1)
{
}

IUTEST(Test, Test2)
{
}

class TestFixed : public iutest::Test
{
protected:
	static int x;
public:
	virtual void SetUp(void)
	{
		++x;
	}
	static void SetUpTestCase(void)
	{
		x = 0;
	}
};
int TestFixed::x = -1;

IUTEST_F(TestFixed, Test1)
{
	IUTEST_ASSERT_EQ(1, x);
}

IUTEST_F(TestFixed, Test2)
{
	IUTEST_ASSERT_EQ(2, x);
}

class TestP : public iutest::TestWithParam<int>
{
};

IUTEST_INSTANCE_P(TestPInstance, TestP, iutest::Range<int>(0, 10));

IUTEST_P(TestP, TestA)
{
	static int x=0;
	IUTEST_ASSERT_EQ(x, GetParam());
	++x;
}

IUTEST_P(TestP, TestB)
{
	static int x=0;
	IUTEST_ASSERT_EQ(x, GetParam());
	++x;
}

IUTEST(TestOp, EQ)
{
	int x=0, y=0;
	IUTEST_ASSERT_EQ(x, y);
}

IUTEST(TestOp, NE)
{
	int x=0, y=1;
	IUTEST_ASSERT_NE(x, y);
}

IUTEST(TestOp, LE)
{
	{
		unsigned long x=1, y=1;
		IUTEST_ASSERT_LE(x, y);
	}
	{
		double x=0, y=1;
		IUTEST_ASSERT_LE(x, y);
	}
}

IUTEST(TestOp, LT)
{
	double x=0, y=1;
	IUTEST_ASSERT_LT(x, y);
}

IUTEST(TestOp, GE)
{
	{
		unsigned long x=1, y=1;
		IUTEST_ASSERT_GE(y, x);
	}
	{
		double x=0, y=1;
		IUTEST_ASSERT_GE(y, x);
	}
}

IUTEST(TestOp, GT)
{
	double x=0, y=1;
	IUTEST_ASSERT_GT(y, x);
}

IUTEST(TestOp, STREQ)
{
	const char e[] = "test";
	IUTEST_ASSERT_STREQ(e, "test");
}

IUTEST(TestOp, STRNE)
{
	const wchar_t e[] = L"test";
	IUTEST_ASSERT_STRNE(e, L"tset");
}

#if defined(SHOW_FAILER)	// Failer Test


IUTEST(TestFailer, EQ)
{
	IUTEST_ASSERT_EQ(0, 1);
}

IUTEST(TestFailer, NE)
{
	int x=1, y=1;
	IUTEST_ASSERT_NE(x, y);
}

IUTEST(TestFailer, GE)
{
	float a = 0.1f, b = 1.0f;
	IUTEST_ASSERT_GE(a, b);
}

IUTEST(TestFailer, TRUE)
{
	IUTEST_ASSERT_TRUE(0);
}

IUTEST(TestFailer, FALSE)
{
	IUTEST_ASSERT_FALSE(true);
}

IUTEST(TestExpectFailer, EQ)
{
	IUTEST_EXPECT_EQ(0.1, 1);
	IUTEST_EXPECT_NE(0, 0);
	IUTEST_EXPECT_LE(2, 0);
	IUTEST_EXPECT_LT(0, 0);
	IUTEST_EXPECT_GE(0, 2);
	IUTEST_EXPECT_GT(0, 0);
	IUTEST_EXPECT_TRUE(0);
	IUTEST_EXPECT_FALSE(1);
}

#endif

#endif

