//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		cMain.cpp
* @brief		Bocachica Ct@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "cMain.h"
#include "../../resource.h"
#include "win/shell/dialog/WXSHAbout.h"
#include "win/control/WXMenu.h"
#include "win/registry/WXMappedProfile.h"
#include "win/exp/shell/WXSplashWindow.h"
#include "win/gdi/WXRegion.h"
#include "win/gdi/WXGdiBitmap.h"
#include <commctrl.h>

#include "win/debug/WXDebug.h"

//======================================================================
// define
#define INI_PATH	TEXT("./setup.ini")

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMain::CMain(void)
: CApp(TEXT("Bocachica"))
{
	IrisRGBA5551 rgba;
	rgba.col = 0;
	rgba.a = 1;
	rgba.r = 0x1F;
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMain::~CMain(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
bool CMain::OnInit(void)
{
	// EBhE
	class CSplash : public wx::CSplashWindowEx
	{
	protected:
		virtual bool OnInit(void)
		{
			if( !wx::CSplashWindowEx::OnInit() ) return false;

			iris::wx::CRegion rgn;
#if 0
			rgn.Load(IRIS_TEXT("../iris_region.rgn"));
#else
			RECT rc;
			GetClientRect(&rc);
			rgn.CreateRoundRect(&rc, 20, 20);
#endif
			SetWindowRgn(rgn, FALSE);
			return true;
		}
	};
	//m_Flags.EnableFlag(MAF_TRANS_ALL);

	m_StatusBar.Create(WS_CHILD|SBARS_SIZEGRIP|CCS_BOTTOM, m_hWnd, 1000, m_hInst);

#if 1
	CSplash SplashWnd;

	// s
	SplashWnd.Setup(m_hInst, m_hWnd
		, 640, 640
		, wx::CSplashWindowEx::INITWND_ALL, IDI_ICON1, IDB_BITMAP1
		);

	SplashWnd.Exec();

	return OnInitThread(&SplashWnd);
#else
	wx::CSplashWindowFunctor<CMain, InitFunctor, CSplash> SplashWnd(this);

	// s
	SplashWnd.Setup(m_hInst, m_hWnd
		, 640, 640
		, wx::CSplashWindowEx::INITWND_ALL, IDI_ICON1, IDB_BITMAP1
		);
	return SplashWnd.Exec();
#endif
}

bool CMain::OnInitThread(void* arg)
{
	wx::CSplashWindowEx* pInit = static_cast<wx::CSplashWindowEx*>(arg);
	pInit->SetProgressRatio(0.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT2, TEXT("AvP[V̏"));
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("AvP[V̏"));

	m_Menu1.LoadMenu(m_hInst, (LPCTSTR)IDR_MENU1);
	m_Menu2.LoadMenu(m_hInst, (LPCTSTR)IDR_MENU2);

	pInit->SetProgressRatio(10.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("Initialize Accelerator."));

	wx::CCustomAccel::ACCELINFO ai[] = {
		{ 0, IDM_NEWDOC		, 'N'		,	FK|FC	, true	, TEXT("VK쐬"), },
		//{ 0, IDM_CLOSE		, VK_F4		,	FK|FC	, true	, TEXT(""), },
		{ 1, IDM_ACCELEDIT	, 0			,	0		, false	, TEXT("ANZ[^L[ҏW"), },
		{ 2, IDM_MDICASCADE	, 0			,	0		, false	, TEXT("d˂ĕ\"), },
		{ 2, IDM_MDITITLEH	, 0			,	0		, false	, TEXT("㉺ɕׂĕ\"), },
		{ 2, IDM_MDITITLEV	, 0			,	0		, false	, TEXT("Eɕׂĕ\"), },
		{ 2, IDM_ICONRANGE	, 0			,	0		, false	, TEXT("ACR̐"), },
		{ 3, IDM_VERSION	, VK_F12	,	FK		, false	, TEXT("o[W"), },
	};
	HICON	hIcon = LoadIcon(m_hInst, (LPCTSTR)IDI_ICON1);
	m_CustomAccel.Initialize(m_hInst, m_Menu2, hIcon
		, ai	, sizeof(ai)/sizeof(wx::CCustomAccel::ACCELINFO)
		, nullptr	, 0
		, nullptr	, 0 );
	DestroyIcon(hIcon);
	m_CustomAccel.AutoSetGroupName();
	
	pInit->SetProgressRatio(30.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("Loading Accelerator."));

	Sleep(1000);

	wx::CMappedPrivateProfile profile;
	profile.Open(INI_PATH);
	profile.MakeProfileList();

	m_CustomAccel.Load(INI_PATH);
	m_Accel = m_CustomAccel.SetAccel(m_Accel.Detach());
	m_CustomAccel.SetMenu(m_Menu1);
	m_CustomAccel.SetMenu(m_Menu2);

	pInit->SetProgressRatio(50.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("Create StatusBar."));


	// status bar
	m_StatusBar.ShowWindow(SW_SHOW);
	m_StatusBar.Simple(1);
	// observero^
	AttachObserver( &m_StatusBar );

	pInit->SetProgressRatio(60.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("Wait..."));

	ShowWindow(SW_SHOW);

	Sleep(200);

	pInit->SetProgressRatio(100.0f);
	pInit->SetText(wx::CSplashWindowEx::INITWND_TEXT1, TEXT("Finish!!"));

	Sleep(1000);

	return CApp::OnInit();
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void CMain::Transaction(void)
{
	CApp::Transaction();
}

/**********************************************************************//**
 *
 * MDIpj[nh̎擾
 *
*//***********************************************************************/
HMENU CMain::GetMDIMenuHandle(bool isDoc) const
{
	if( isDoc ) return m_Menu2;
	return m_Menu1;
}

/**********************************************************************//**
 *
 * MDIEBhEpj[nh̎擾
 *
*//***********************************************************************/
HMENU CMain::GetMDIWindowMenuHandle(HMENU hMenu) const
{
	if( hMenu == m_Menu1 ) return nullptr;
	int n_menu = GetMenuItemCount(hMenu);
	return GetSubMenu( hMenu, n_menu-2 ); 
}

/**********************************************************************//**
 *
 * Command
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CMain, Command)
{
	IRIS_UNUSED_VAR(lParam);

	DWORD cmd = LOWORD(wParam);
	switch(cmd)
	{
	case IDM_NEWDOC:
		CreateDoc(TEXT("VK"),0,256,256,0);
		break;
	case IDM_CLOSE:
		MDIDestroy(MDIGetActive());
		break;
	case IDM_MDICASCADE:
		MDICascade();
		break;
	case IDM_MDITITLEH:
		MDITileH();
		break;
	case IDM_MDITITLEV:
		MDITileV();
		break;
	case IDM_ICONRANGE:
		MDIIconarRange();
		break;

	// ANZ[^L[ҏW
	case IDM_ACCELEDIT:
		switch( m_CustomAccel.OpneDlg(hWnd,TEXT("ANZ[^L[ҏW")) )
		{
		case IDOK:
			m_Accel = m_CustomAccel.SetAccel(m_Accel.Detach());
			m_CustomAccel.SetMenu(m_Menu1);
			m_CustomAccel.SetMenu(m_Menu2);
			break;
		}
		break;
	// o[W
	case IDM_VERSION:
		{
			HICON hIcon = LoadIcon(m_hInst,(LPCTSTR)IDI_ICON1);
			CSHAbout::ShowFromVersionInfo(hWnd, iris::wx::VERDLG_MASK_LEGALCOPYRIGHT, hIcon);
			DestroyIcon(hIcon);
		}
		break;

	case IDM_EXIT:
		::SendMessage(hWnd,WM_CLOSE,0,0);
		break;
	}
	return 1;
}

/**********************************************************************//**
 *
 * MenuSelect
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CMain, MenuSelect)
{
	WORD id = LOWORD(wParam);
	TCHAR buf[256];
	if( wx::GetMenuStringFromID(::GetMenu(hWnd), id, buf, 256) )
	{
		m_StatusBar.SetTextEx(WX_SB_SIMPLEMODE_PARTS, buf, buf);
	}
	return CApp::__IrisAppEventFuncName(MenuSelect)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * ExitMenuLoop
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CMain, ExitMenuLoop)
{
	m_StatusBar.SetText(WX_SB_SIMPLEMODE_PARTS, nullptr);
	return CApp::__IrisAppEventFuncName(ExitMenuLoop)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Destroy
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CMain, Destroy)
{
	m_CustomAccel.Save(INI_PATH);
	return CApp::__IrisAppEventFuncName(Destroy)(hWnd, wParam, lParam);
}

/**********************************************************************//**
 *
 * Size
 *
*//***********************************************************************/
__IrisAppEventFuncImpl(CMain, Size)
{
	int w = LOWORD(lParam);
	int h = HIWORD(lParam);
	RECT rc;
	m_StatusBar.GetWindowRect(&rc);
	::MoveWindow(m_hMDIClient, 0, 0, w, h-(rc.bottom-rc.top),TRUE);
	return CApp::__IrisAppEventFuncName(Size)(hWnd, wParam, lParam);
}

#if	defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST)
#include "unit/UnitCore.h"
#include "iris_iostream.h"
#include "iris_using.h"

IRIS_UNITTEST(sample, test)
{
}

#endif
