//======================================================================
//-----------------------------------------------------------------------
// 
// MDIhLgNX(DirectX)t@C
//
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include <tchar.h>
#include "cDoc.h"
#include "win/gdi/WXDeviceContext.h"
#include "d3dx/dxgx.h"
#include "d3dx/math/DXMatrix.h"
#include "d3dx/DXError.h"
#include "win/image/WXScopedCursor.h"

#include "win/debug/WXDebug.h"
#include "win/debug/WXDebugLeakCheckMacro.h"

//======================================================================
// define
// C[̊ǗCDXObjectManagerɈϑ
#define USING_OBJECTMAN

//======================================================================
// class

//**********************************************************************
//
// RXgN^
//
//**********************************************************************
CDoc::CDoc(HWND hWnd, LPDOCPARAMS pDocParam)
: CDXDoc(hWnd, pDocParam, &m_Timer)
, m_ObjMan(&m_SwapChain)
, m_Camera(&D3DXVECTOR3(0.0f,0.0f,-10.0f))
{
	m_Edge.SetKernel(0, &m_Laplacian);
	m_Edge.SetKernel(1, nullptr);
}

//**********************************************************************
//
// fXgN^
//
//**********************************************************************
CDoc::~CDoc(void)
{
#ifndef USING_OBJECTMAN
	// new C[폜
	m_Device.ReleaseLayerAll();
#endif
}

//**********************************************************************
//
// XV
//
//**********************************************************************
void CDoc::Transaction(void)
{
	m_pTimer->Resume();
	CDXDoc::Transaction();
}

//**********************************************************************
//
// `
//
//**********************************************************************
void CDoc::Draw(void)
{
	if( m_SwapChain.BeginScene() )
	{
		m_SwapChain.Draw();

		// DCɕ`
		HDC hdc = NULL;
		DX_CHECK_RESULT( m_SwapChain.GetDC(&hdc) );
		iris::wx::CDeviceContext DC(hdc);
		DC.MoveToEx(0, 0);
		DC.LineTo(100, 100);
		char str[256];
		sprintf_s(str, 256, "timer %f",m_Timer.GetStockSecond()); 
		DC.TextOut(0, 200, (int)strlen(str), str);

		//m_Edge.Detect(&DC, &DC, 1.0f/8);
		m_SwapChain.ReleaseDC( DC.Detach() );

		if( m_SwapChain.EndScene() )
		{
			m_SwapChain.Present();
		}
	}
}

//**********************************************************************
//
// Create
//
//**********************************************************************
__IrisDocEventFuncImpl(CDoc, Create)
{
	// vACR
	iris::wx::CWaitCursor waitCursor;

	LRESULT ret = CDXDoc::__IrisDocEventFuncName(Create)(hWnd, wParam, lParam);
	if( ret == -1 ) return ret;
	m_pDevice->CreateSprite();

	// Layer
#ifdef USING_OBJECTMAN
#if 1
	for( int i=0; i < LAYER_NUM; ++i )
	{
		m_ObjMan.CreateLayer<CDXLayer>(i);
	}
#else
	m_ObjMan.CreateLayer<CDXLayer>(LAYER_TEXTURE);
	m_ObjMan.CreateLayer<CDXLayer>(LAYER_MODEL);
	m_ObjMan.CreateLayer<CDXLayer>(LAYER_FONT);
	//m_ObjMan.CreateLayer<CDXLayer>(LAYER_FILTER);
#endif

#else
	//m_Device.RegisterLayer(0, new iris::dx::CDXDefaultLayer);
	m_Device.RegisterLayer(3, new iris::dx::CDXLayer);
	m_Device.RegisterLayer(1, new iris::dx::CDXLayer);
	m_Device.RegisterLayer(2, new iris::dx::CDXLayer);
	m_Device.RegisterLayer(0, new iris::dx::CDXLayer);
#endif
	// Camera
	m_SwapChain.RegisterObject(0, &m_Camera);

	// Texture
#if 1

	{
		m_SwapChain.RegisterDeviceObject(&m_Texture);
		if( m_Texture.Load(TEXT("../../../data/image/sample.tga")) )
		{
#if 0
			iris::dx::CDXRenderTextureUp* p = m_ObjMan.CreateLayerObject<iris::dx::CDXRenderTextureUp>( LAYER_TEXTURE );
#else
			iris::dx::CDXRenderTexture* p = m_ObjMan.CreateLayerObject<iris::dx::CDXRenderTexture>( LAYER_TEXTURE );
#endif
			if( p != nullptr )
			{
				D3DXMATRIX mat;
				p->SetTexture(&m_Texture);
				D3DXMatrixIdentity(&mat);
				p->SetWorldMatrix(&mat);
				p->SetTextureSize(D3DXVECTOR2(10, 10));
				p->Build();
			}
		}
	}
#else
	m_SwapChain.RegisterDeviceObject(&m_Texture);
	if( m_Texture.Load(TEXT("../../../data/image/sample.tga")) )
	{
		CDXFilter<CDXSpriteTexture>* p = m_ObjMan.CreateLayerObject< CDXFilter<CDXSpriteTexture> >( LAYER_TEXTURE );
		if( p != nullptr )
		{
			D3DXMATRIX mat;
			p->SetTexture(&m_Texture);
			D3DXMatrixIdentity(&mat);
			p->SetWorldMatrix(&mat);
			p->Build();
		}
	}
#endif

	// Mesh
	{
		D3DXMATRIX mat;
		if( m_SwapChain.RegisterObject(LAYER_MODEL, &m_Mesh) )
		{
			m_Mesh.LoadDirectory(TEXT("../../../data/model"),TEXT("sample.x"));
			D3DXMatrixIdentity(&mat);
			m_Mesh.SetWorldMatrix(&mat);
		}

		iris::dx::CDXMeshSimple* p = m_ObjMan.CreateLayerObject<iris::dx::CDXMeshSimple>( LAYER_MODEL );
		if( p != nullptr )
		{
			p->LoadDirectory(TEXT("../../../data/model"), TEXT("arrow.x"));
			D3DXMatrixIdentity(&mat);
			p->SetWorldMatrix(&mat);
		}
	}

	// Light
	m_Light.SetDirectionalLight(  &DXICOLOR(1.0f,1.0f,1.0f,1.0f)
								, &DXICOLOR(1.0f,1.0f,1.0f,1.0f)
								, &DXICOLOR(1.0f,1.0f,1.0f,1.0f)
								, &D3DXVECTOR3(0.0f,-10.0f,10.0f));
	m_SwapChain.RegisterDeviceObject(&m_Light);
	m_pDevice->SetLight(0, &m_Light);

	// font
	{
		LPTSTR text = TEXT("eXg");
		//m_Device.CreateLayerObject(LAYER_FONT,&m_Font);
		m_Font.CreateFont(50,0,FW_NORMAL,0,0,0
			, SHIFTJIS_CHARSET
			, OUT_TT_PRECIS
			, PROOF_QUALITY
			, FIXED_PITCH | FF_MODERN
			, TEXT("lr ") );
		m_Font.SetFontColor(0xFFFF0000);
		m_Font.Create(300,300);
		m_Font.Clear();
		m_Font.TextOut(0,0,text,_tcslen(text));
		m_Font.EnableRenderState(iris::dx::DXRS_DRAWSPRITE);

		CDXGlyphFont* pFont = m_ObjMan.CreateLayerObject<CDXGlyphFont>(LAYER_FONT);
		if( pFont != nullptr )
		{
			pFont->Create(200,200);
			pFont->CreateFont(50,0,FW_NORMAL,0,0,0
				, SHIFTJIS_CHARSET
				, OUT_TT_PRECIS
				, PROOF_QUALITY
				, FIXED_PITCH | FF_MODERN
				, TEXT("lr ") );
			pFont->Clear();
			pFont->SetFontColor(0xFF22FF22);
			pFont->TextOut(0,0,text,_tcslen(text),true,false,true);
			pFont->EnableRenderState(DXRS_DRAWSPRITE);
		}
	}

	// bZ[W
	{
		LPTSTR res  = TEXT("");
		LPTSTR text = TEXT("");
		iris::dx::CDXFontInfo info;
		info.SetHeight(30).SetFaceName(TEXT("lr "));

		if( m_SwapChain.RegisterObject(LAYER_FONT, &m_Message) )
		{
			m_Message.CreateResource(0, 512, 512, &info);
			m_Message.WriteResource(0, res, _tcslen(res));
			iris::dx::CDXMessage* msg = m_Message.CreateMessage(0,0);
			iris::dx::CDXMessageData* data = msg->CreateMessageData(0);
			data->EnableRenderState(iris::dx::DXRS_DRAWSPRITE);
			data->SetCode(text, _tcslen(text));
		}
	}
	// J[tB^[
	{
		CDXColorFilter* filter = m_ObjMan.CreateLayerObject<CDXColorFilter>(LAYER_FILTER);
		if( filter != nullptr ) filter->SetColor(0x99FFFF00);

		CDXFade* fade = m_ObjMan.CreateLayerObject<CDXFade>(LAYER_FILTER);
		if( fade != nullptr )
		{
			fade->SetFadeColor(0xFF00FFFF);
			fade->SetFadeAlpha(1.0f);
			fade->ChangeFadeColor();
			fade->FadeInT(0.0f,2.0f);
		}

		//CDXGammaRamp* gamma = m_DeviceEx.CreateLayerObject<CDXGammaRamp>(LAYER_FILTER);
		//if( gamma != NULL )
		//{
		//	gamma->SetGamma(1, DXGammaCurveLiner);
		//}
	}
	return ret;
}

//**********************************************************************
//
// Destroy
//
//**********************************************************************
__IrisDocEventFuncImpl(CDoc, Destroy)
{
	return CDXDoc::__IrisDocEventFuncName(Destroy)(hWnd, wParam, lParam);
}
