//==================================================
//
// WinMain.cpp
//
//==================================================
#include "main/cMain.h"
#include "d3dx/DXLib.h"

#include "win/debug/WXDebugConsole.h"
#include "win/debug/WXDebugLeakCheckMacro.h"
#include "win/debug/dbghelp/WXObjLeakCheck.h"
#include "win/wx.h"
#include "iris_main.h"
#include <string>

IRIS_OBJLEAKCHECK_ENABLE(0xFFFFFFFF);

//**********************************************************************
// C[`
//**********************************************************************
int iris_main(void)
{
	iris::wx::dbg::DebugConsoleOpen(true, true);

	// VXe
	wx::WXInit();

	CMain& rMain = CMain::CreateInstance();
	if(rMain.Init()) 
	{
		// AvP[V̎s
		rMain.RunAsync();
	}

	CMain::DeleteInstance();

	iris::wx::dbg::DebugConsoleClose();

	iris::dx::ReleaseDxLibAll();

	// VXe
	wx::WXTerm();

	return 0;
}
