ENTRY(_startup)

MEMORY
{
    rom (rx)  : ORIGIN = 0x08000000, LENGTH = 128K
    ram (rwx) : ORIGIN = 0x20000000, LENGTH = 20K
}

SECTIONS
{
	.vector : {
		*(.isr_vector)  /* Vector table   */
	} > rom

	.text : {
		.obj/Release/startup.o(.text)
		*(.text)
		*(.rodata)
	} > rom

	.data (NOLOAD) : {
		*(.data)
		*(.zdata)
	} > ram AT > rom

	.bss (NOLOAD) : {
		*(.bss)
		*(.comment)
	} > ram AT > rom

	_end = .;
	
    _sidata = ABSOLUTE( LOADADDR( .data));
    _stext  = ABSOLUTE( ADDR( .text));
    _etext	= _stext + SIZEOF( .text);
    _sdata  = ABSOLUTE( ADDR( .data));
    _edata  = _sdata + SIZEOF( .data);
    _sbss   = ABSOLUTE( ADDR( .bss));
    _ebss   = _sbss + SIZEOF( .bss);

	. = ALIGN(0x4);
	. += 0x200;
	_sp_base = .;
}
