@echo off
pushd "%~dp0"
call _setenv.bat

if "x%~1" == "x" goto error

SET VSYEAR=%~1
SET VSVER=vs%~1

if not exist "%ANGELSCRIPT_ROOT%" goto error
if not exist "%ANGELSCRIPT_SDK_ROOT%" goto error

SET ANGELSCRIPT_LIB=%ANGELSCRIPT_SDK_ROOT%\lib

rem rh
call "%BAT_TOOLS_ROOT%\msbuildvars.bat" %VSVER%

cd "%ANGELSCRIPT_SDK_ROOT%"
if errorlevel 1 goto error

cd projects
if errorlevel 1 goto error

cd msvc%VSMAJOR%
if errorlevel 1 goto error

SET PROJECT_NAME=angelscript

rem build

rem MT
rem x86
msbuild /p:Configuration=Debug		/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%.sln
if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%.sln
if errorlevel 1 goto error

rem x64
msbuild /p:Configuration=Debug		/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%.sln
rem if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%.sln
rem if errorlevel 1 goto error

@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%d.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%_x64.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_mt%VSYEAR%_x64d.lib"

rem MD
@echo | sed -e "s/RuntimeLibrary=\"2\"/RuntimeLibrary=\"0\"/g" %PROJECT_NAME%.vcproj  > %PROJECT_NAME%.tmp
@echo | sed -e "s/RuntimeLibrary=\"3\"/RuntimeLibrary=\"1\"/g" %PROJECT_NAME%.tmp > %PROJECT_NAME%-md.vcproj
del %PROJECT_NAME%.tmp

rem x86
msbuild /p:Configuration=Debug		/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%-md.vcproj
if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=Win32	/t:Rebuild	%PROJECT_NAME%-md.vcproj
if errorlevel 1 goto error

rem x64
msbuild /p:Configuration=Debug		/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%-md.vcproj
rem if errorlevel 1 goto error
msbuild /p:Configuration=Release	/p:Platform=x64		/t:Rebuild	%PROJECT_NAME%-md.vcproj
rem if errorlevel 1 goto error

@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%d.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%_x64.lib"
@echo F | xcopy /Y /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64d.lib"	"%ANGELSCRIPT_LIB%\%PROJECT_NAME%_static_md%VSYEAR%_x64d.lib"

:clean
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%d.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64.lib"
del /F /Q "%ANGELSCRIPT_LIB%\%PROJECT_NAME%64d.lib"

goto end

:error
exit /b 1

:end
popd

exit /b 0

