//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XpiSysTime.cpp
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_XpiSysTime_CPP_

//======================================================================
// include
#include "XpiSysTime.h"

namespace iris {
namespace xpi
{

//======================================================================
// class
// VXeԏpNX
namespace 
{

class CSysTime : public IIrisObject
{
public:
#if		defined(IRIS_WIN32)
	LARGE_INTEGER	m_Freq;
	IrisBool		m_bInit;
#endif
public:
	// RXgN^
	CSysTime(void)
	{
		Init();
	}
	// 
	void	Init(void)
	{
#if		defined(IRIS_WIN32)
		if( QueryPerformanceFrequency(&m_Freq) )
			m_bInit = IRIS_TRUE;
#else
#endif
	}
};

}

//======================================================================
// variable
static CSysTime	s_SysTime;

//======================================================================
// function

/**********************************************************************//**
 *
 * `bNVXȅ
 *
 * @note	staticIuWFNg̃RXgN^ŎsĂ邽߁AIɌĂяoKv͂Ȃ
 *
*//***********************************************************************/
void CSysTick::Initialize(void)
{
	s_SysTime.Init();
}

/**********************************************************************//**
 *
 * VXeς݂ǂ
 *
 -----------------------------------------------------------------------
 * @return ^Ul
*//***********************************************************************/
IrisBool CSysTick::IsTickAvailable(void)
{
#if		defined(IRIS_WIN32)
	return s_SysTime.m_bInit;
#else
	return IRIS_FALSE;
#endif
}

/**********************************************************************//**
 *
 * `bNl̎擾
 *
 -----------------------------------------------------------------------
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::GetTick(void)
{
#if		defined(IRIS_WIN32)
	LARGE_INTEGER cnt;
	QueryPerformanceCounter(&cnt);
	return cnt.QuadPart;
#else
	return 0;
#endif
}

/**********************************************************************//**
 *
 * `bNl̉16bit擾
 *
 -----------------------------------------------------------------------
 * @return `bNl̉16bit
*//***********************************************************************/
u16 CSysTick::GetTickLo(void)
{
	return (u16)(GetTick() & 0xFFFF);
}

/**********************************************************************//**
 *
 * `bNlbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return b
*//***********************************************************************/
u64 CSysTick::TicksToSeconds(u64 tick)
{
#if		defined(IRIS_WIN32)
	return tick / s_SysTime.m_Freq.QuadPart;
#else
	return tick;
#endif
}

/**********************************************************************//**
 *
 * `bNl~bɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return ~b
*//***********************************************************************/
u64 CSysTick::TicksToMilliSeconds(u64 tick)
{
#if		defined(IRIS_WIN32)
	return tick * 1000 / s_SysTime.m_Freq.QuadPart;
#else
	return tick;
#endif
}

/**********************************************************************//**
 *
 * `bNl}CNbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return }CNb
*//***********************************************************************/
u64 CSysTick::TicksToMicroSeconds(u64 tick)
{
#if		defined(IRIS_WIN32)
	return tick * 1000000 / s_SysTime.m_Freq.QuadPart;
#else
	return tick;
#endif
}

/**********************************************************************//**
 *
 * `bNlimbɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	tick	= `bNl
 * @return imb
*//***********************************************************************/
u64 CSysTick::TicksToNanoSeconds(u64 tick)
{
#if		defined(IRIS_WIN32)
	return tick * (1000000000 / s_SysTime.m_Freq.QuadPart);
#else
	return tick;
#endif
}

/**********************************************************************//**
 *
 * b`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= b
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::SecondsToTicks(u64 sec)
{
#if		defined(IRIS_WIN32)
	return sec * s_SysTime.m_Freq.QuadPart;
#else
	return sec;
#endif
}


/**********************************************************************//**
 *
 * ~b`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= ~b
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::MilliSecondsToTicks(u64 sec)
{
#if		defined(IRIS_WIN32)
	return sec / 1000 * s_SysTime.m_Freq.QuadPart;
#else
	return sec;
#endif
}

/**********************************************************************//**
 *
 * }CNb`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= }CNb
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::MicroSecondsToTicks(u64 sec)
{
#if		defined(IRIS_WIN32)
	return sec / 1000000 * s_SysTime.m_Freq.QuadPart;
#else
	return sec;
#endif
}

/**********************************************************************//**
 *
 * imb`bNlɕϊ
 *
 -----------------------------------------------------------------------
 * @param [in]	sec	= imb
 * @return `bNl
*//***********************************************************************/
u64 CSysTick::NanoSecondsToTicks(u64 sec)
{
#if		defined(IRIS_WIN32)
	return sec / 1000000000 * s_SysTime.m_Freq.QuadPart;
#else
	return sec;
#endif
}

}	// end of namespace xpi
}	// end of namespace iris
