//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFPlane.inl
 * @brief		ʉZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFPlane_inl_
#define INCG_IRIS_MathXFPlane_inl_

namespace iris {
namespace xf
{

//======================================================================
// function
/**
 * @brief	ʂ̐
 * @param [out]	pl0	= o͕
 * @param [in]	a	= vfa
 * @param [in]	b	= vfb
 * @param [in]	c	= vfc
 * @param [in]	d	= vfd
 * @return	o͕
*/
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneSet(IrisXFPlane* pl0, xf32 a, xf32 b, xf32 c, xf32 d)
{
	XFPU_NULLASSERT( pl0 );
	pl0->a = a;
	pl0->b = b;
	pl0->c = c;
	pl0->d = d;
	return pl0;
}

/**
 * @brief	ʂ̃Rs[
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneCopy(IrisXFPlane* pl0, const IrisXFPlane* pl1)
{
	XFPU_NULLASSERT( pl0 );
	XFPU_NULLASSERT( pl1 );
	pl0->a = pl1->a;
	pl0->b = pl1->b;
	pl0->c = pl1->c;
	pl0->d = pl1->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̉Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 
 * @param [in]	pl2	= 
 * @return	o͕
*/
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneAdd(IrisXFPlane* pl0, const IrisXFPlane* pl1, const IrisXFPlane* pl2)
{
	XFPU_NULLASSERT( pl0 );
	XFPU_NULLASSERT( pl1 );
	XFPU_NULLASSERT( pl2 );
	pl0->a = pl1->a + pl2->a;
	pl0->b = pl1->b + pl2->b;
	pl0->c = pl1->c + pl2->c;
	pl0->d = pl1->d + pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̓m̌Z
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= 팸
 * @param [in]	pl2	= 
 * @return	o͕
*/
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneSub(IrisXFPlane* pl0, const IrisXFPlane* pl1, const IrisXFPlane* pl2)
{
	XFPU_NULLASSERT( pl0 );
	XFPU_NULLASSERT( pl1 );
	XFPU_NULLASSERT( pl2 );
	pl0->a = pl1->a - pl2->a;
	pl0->b = pl1->b - pl2->b;
	pl0->c = pl1->c - pl2->c;
	pl0->d = pl1->d - pl2->d;
	return pl0;
}

/**
 * @brief	ʂ̖@1ɂȂ悤ɐK
 * @param [out]	pl0	= o͕
 * @param [in]	pl1	= ͕
 * @return	o͕
*/
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneNormalize(IrisXFPlane* pl0, const IrisXFPlane* pl1)
{
	xf32 a = pl1->a;
	xf32 b = pl1->b;
	xf32 c = pl1->c;
	xf32 d = pl1->d;
	xf32 q = XF32_Div(XF32_ONE, XF_Sqrt(XF32_Mul(a, a) + XF32_Mul(b, b) + XF32_Mul(c, c)) );
	if(q!=XF32_ZERO) q = XF32_Div(XF32_ONE, q);

	pl0->a = XF32_Mul(a, q);
	pl0->b = XF32_Mul(b, q);
	pl0->c = XF32_Mul(c, q);
	pl0->d = XF32_Mul(d, q);
	return pl0;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
IRIS_XFPU_INLINE xf32			XFpuPlaneVec3Distance(const IrisXFPlane* pl0, const IrisXFVec3* pv0)
{
	xf32 n = XF_Sqrt( XF32_Mul(pl0->a, pl0->a) + XF32_Mul(pl0->b, pl0->b) + XF32_Mul(pl0->c, pl0->c));
	xf32 f = XF_Abs( XF32_Div((XF32_Mul(pl0->a, pv0->x) + XF32_Mul(pl0->b, pv0->y) + XF32_Mul(pl0->c, pv0->z) + pl0->d), n));
	return f;
}

/**
 * @brief	ʂƓ_̋vZ
 * @param [out]	pl0	= 
 * @param [in]	pv0	= _
 * @return	
*/
IRIS_XFPU_INLINE xf32			XFpuPlaneVec4DistanceXYZ(const IrisXFPlane* pl0, const IrisXFVec4* pv0)
{
	xf32 n = XF_Sqrt( XF32_Mul(pl0->a, pl0->a) + XF32_Mul(pl0->b, pl0->b) + XF32_Mul(pl0->c, pl0->c));
	xf32 f = XF_Abs( XF32_Div((XF32_Mul(pl0->a, pv0->x) + XF32_Mul(pl0->b, pv0->y) + XF32_Mul(pl0->c, pv0->z) + pl0->d), n));
	return f;
}

}	// end of namespace xf
}	// end of namespace iris

#endif
