//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFpuTest.cpp
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_MathXFpuTest_CPP_

//======================================================================
// include
#include "MathXFMatrix22.h"
#include "MathXFMatrix33.h"
#include "MathXFMatrix44.h"
#include "MathXFPerspective.h"
#include "MathXFPlane.h"
#include "MathXFQuaternion.h"
#include "MathXFVector2.h"
#include "MathXFVector3.h"
#include "MathXFVector4.h"
#include "MathXFpuInline.h"
#include "MathXFpu.h"
#include "MathXFScalar.h"
#include "MathXFColor.h"
#include "MathXFComplex.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"

//======================================================================
// test
IRIS_UNITTEST(CMathXFpuUnitTest, MathXFpuUnitTest)
{
//#if	defined(__MWERKS__)
//	IrisXFVec4 vec = {.x=XF32_ZERO, .y=XF32_ZERO, .z=XF32_ZERO, .w=XF32_ZERO};
//	vec = (IrisXFVec4){.x=XF32_ZERO, .y=XF32_ZERO, .z=XF32_ZERO, .w=XF32_ZERO};
//#endif

	// log2
	IRIS_ASSERT( XF_XF32_TO_S32(XF32_Log2(XF32_CONST(128.0f))) == 7 );
	IRIS_ASSERT( XF_XF32_TO_S32(XF32_Log2(XF32_CONST(127.0f))) == 6 );
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
