//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFVector4.h
 * @brief		4DxNgt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFVector4_H_
#define INCG_IRIS_MathXFVector4_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Set(IrisXFVec4* pv0, xf32 x, xf32 y, xf32 z, xf32 w);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4SetXYZ(IrisXFVec4* pv0, xf32 x, xf32 y, xf32 z);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Copy(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4PositiveZero(IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4NegativeZero(IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisIVec4*		XFpuVec4Ceil(IrisIVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisIVec4*		XFpuVec4Trunc(IrisIVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisIVec4*		XFpuVec4Round(IrisIVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisIVec4*		XFpuVec4Floor(IrisIVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4FromIVec4(IrisXFVec4* pv0, const IrisIVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Add(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4AddXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Sub(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4SubXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Mul(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4MulXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Div(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4DivXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Neg(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Abs(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Lerp(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4LerpXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Scale(IrisXFVec4* pv0, const IrisXFVec4* pv1, xf32 s);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4ScaleXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, xf32 s);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4ScaleAdd(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 s);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4ScaleAddXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 s);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Hermite(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pt1
										, const IrisXFVec4* pv2, const IrisXFVec4* pt2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4HermiteXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pt1
										, const IrisXFVec4* pv2, const IrisXFVec4* pt2, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Bezier(IrisXFVec4* pv0, s32 n, const IrisXFVec4* pva, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4BezierXYZ(IrisXFVec4* pv0, s32 n, const IrisXFVec4* pva, xf32 t);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Clamp(IrisXFVec4* pv0, const IrisXFVec4* pv1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4ClampXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Max(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Min(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE xf32			XFpuVec4InnerProduct(const IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec4InnerProductXYZ(const IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4OuterProductXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE xf32			XFpuVec4Funnel(const IrisXFVec4* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec4Average(const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuVec4IsEqual(const IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisBool		XFpuVec4IsZero(const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuVec4IsZeroXYZ(const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4SignFloat(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisIVec4*		XFpuVec4SignInt(IrisIVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4Normalize(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4NormalizeXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4NormalizePhase(IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE xf32			XFpuVec4LengthXYZ(const IrisXFVec4* pv0);
IRIS_XFPU_INLINE xf32			XFpuVec4DistanceXYZ(const IrisXFVec4* pv0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4FaceForwardXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, const IrisXFVec4* pv3);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4ReflectXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4RefractXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 eta);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuVec4TruncatePrecision24(IrisXFVec4* pv0, const IrisXFVec4* pv1);

//======================================================================
// inline
STATICINLINE IrisXFVec4*	XFpuVec4Null(IrisXFVec4* pv0)	{ return XFpuVec4PositiveZero(pv0); }
STATICINLINE IrisXFVec4*	XFpuVec4Zero(IrisXFVec4* pv0)	{ return XFpuVec4PositiveZero(pv0); }
STATICINLINE xf32			XFpuVec4Dot(const IrisXFVec4* pv0, const IrisXFVec4* pv1)						{ return XFpuVec4InnerProduct(pv0, pv1); }
STATICINLINE xf32			XFpuVec4DotXYZ(const IrisXFVec4* pv0, const IrisXFVec4* pv1)						{ return XFpuVec4InnerProductXYZ(pv0, pv1); }
STATICINLINE IrisXFVec4*	XFpuVec4Cross(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)		{ return XFpuVec4OuterProductXYZ(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4Subtract(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)	{ return XFpuVec4Sub(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4Multiply(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)	{ return XFpuVec4Mul(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4Divide(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)	{ return XFpuVec4Div(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4SubtractXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)	{ return XFpuVec4SubXYZ(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4MultiplyXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)	{ return XFpuVec4MulXYZ(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4DivideXYZ(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2)		{ return XFpuVec4DivXYZ(pv0, pv1, pv2); }
STATICINLINE IrisXFVec4*	XFpuVec4Inter(IrisXFVec4* pv0, const IrisXFVec4* pv1, const IrisXFVec4* pv2, xf32 t)	{ return XFpuVec4Lerp(pv0, pv1, pv2, t); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFVector4.inl"
#endif

#endif
