//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFScalar.h
 * @brief		XJ[lZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFScalar_H_
#define INCG_IRIS_MathXFScalar_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE xf32	XFpuScalarAbs(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarAcos(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarAsin(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarAtan(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarAtan2(xf32 y, xf32 x);
IRIS_XFPU_INLINE xf32	XFpuScalarCeil(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarCos(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarExp(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarFloor(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarLog(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarLog2(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarLog10(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarMax(xf32 a, xf32 b);
IRIS_XFPU_INLINE xf32	XFpuScalarMin(xf32 a, xf32 b);
IRIS_XFPU_INLINE xf32	XFpuScalarPow(xf32 x, xf32 y);
IRIS_XFPU_INLINE xf32	XFpuScalarPow2(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarRound(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarRsqrt(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarSin(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarSqrt(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarTan(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarTrunc(xf32 fs);
IRIS_XFPU_INLINE xf32	XFpuScalarTruncatePrecision24(xf32 fs);

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFScalar.inl"
#endif

#endif
