//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFPlane.h
 * @brief		ʉZt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFPlane_H_
#define INCG_IRIS_MathXFPlane_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneSet(IrisXFPlane* pl0, xf32 a, xf32 b, xf32 c, xf32 d);
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneCopy(IrisXFPlane* pl0, const IrisXFPlane* pl1);
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneAdd(IrisXFPlane* pl0, const IrisXFPlane* pl1, const IrisXFPlane* pl2);
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneSub(IrisXFPlane* pl0, const IrisXFPlane* pl1, const IrisXFPlane* pl2);
IRIS_XFPU_INLINE IrisXFPlane*	XFpuPlaneNormalize(IrisXFPlane* pl0, const IrisXFPlane* pl1);
IRIS_XFPU_INLINE xf32			XFpuPlaneVec3Distance(const IrisXFPlane* pl0, const IrisXFVec3* pv0);
IRIS_XFPU_INLINE xf32			XFpuPlaneVec4DistanceXYZ(const IrisXFPlane* pl0, const IrisXFVec4* pv0);

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFPlane.inl"
#endif

#endif
