//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFPerspective.h
 * @brief		t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFPerspective_H_
#define INCG_IRIS_MathXFPerspective_H_

//======================================================================
// include
#include "MathXFMatrix44.h"
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuLookAtMatrix(IrisXFMtx44* pm0, const IrisXFVec4* pvEye, const IrisXFVec4* pvLookAt, const IrisXFVec4* pvUp);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuPerspectiveMatrix(IrisXFMtx44* pm0, xf32 fovy, xf32 aspect, xf32 xfNear, xf32 xfFar);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuOrthoMatrix(IrisXFMtx44* pm0, xf32 left, xf32 top, xf32 right, xf32 bottom, xf32 r_near, xf32 r_far);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuFrustumMatrix(IrisXFMtx44* pm0, xf32 left, xf32 top, xf32 right, xf32 bottom, xf32 r_near, xf32 r_far);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuCameraMatrix(IrisXFMtx44* pm0, const IrisXFVec4* pv, const IrisXFVec4* pzd, const IrisXFVec4* pyd);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuViewScreenMatrix(IrisXFMtx44* pm0, xf32 scrz, xf32 ax, xf32 ay, xf32 cx, xf32 cy
													, xf32 zmin, xf32 zmax, xf32 nearz, xf32 farz);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuDropShadowMatrix(IrisXFMtx44* pm0, const IrisXFVec4* lp, xf32 a, xf32 b, xf32 c, int mode);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuRotTransPers(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE int			XFpuRotTransPersN(short* pXyz, int pitch, const IrisXFMtx44* pm0, const IrisXFVec4* pv0, int n);

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFPerspective.inl"
#endif

#endif
