//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFMatrix44.h
 * @brief		4x4}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFMatrix44_H_
#define INCG_IRIS_MathXFMatrix44_H_

//======================================================================
// include
#include "MathXFpuDef.h"
#include "MathXFMatrix33.h"
#include "MathXFVector4.h"
#include "MathXFPlane.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Unit(IrisXFMtx44* pm0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Zero(IrisXFMtx44* pm0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Copy(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44SetTransfer(IrisXFMtx44* pm0, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuMtx44GetTransfer(IrisXFVec4* pv0, const IrisXFMtx44* pm0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Transfer(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuMtx44Transform(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuMtx44TransformXYZ(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1);
IRIS_XFPU_INLINE IrisXFVec4*	XFpuMtx44HomogeneousTransform(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1);	
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Mul(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, const IrisXFMtx44* pm2);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Scale(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, xf32 s);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Transpose(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotZ(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, xf32 rz);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotIdxZ(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, u16 idz);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotY(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, xf32 ry);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotIdxY(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, u16 idy);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotX(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, xf32 rx);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotIdxX(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, u16 idx);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Rot(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, const IrisXFVec4* pv0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44RotIdx(IrisXFMtx44* pm0, const IrisXFMtx44* pm1, const IrisSVec4* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuMtx44IsUnit(const IrisXFMtx44* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx44Trace(const IrisXFMtx44* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx44Determinant(const IrisXFMtx44* pm0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Adjoint(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Inverse(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44Inverse2(IrisXFMtx44* pm0, xf32* pDeterminant, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44DropShadow(IrisXFMtx44* pm0, const IrisXFVec4* pv0, const IrisXFPlane* pl0);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44NormalizeXYZ(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);
IRIS_XFPU_INLINE IrisXFMtx44*	XFpuMtx44TruncatePrecision24(IrisXFMtx44* pm0, const IrisXFMtx44* pm1);

//======================================================================
// inline
STATICINLINE IrisXFMtx44*	XFpuMtx44Identity(IrisXFMtx44* pm0)			{ return XFpuMtx44Unit(pm0); }
STATICINLINE IrisXFMtx44*	XFpuMtx44Null(IrisXFMtx44* pm0)				{ return XFpuMtx44Zero(pm0); }
STATICINLINE IrisXFVec4*	XFpuMtx44Apply(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1)		{ return XFpuMtx44Transform(pv0, pm0, pv1); }
STATICINLINE IrisXFVec4*	XFpuMtx44ApplyXYZ(IrisXFVec4* pv0, const IrisXFMtx44* pm0, const IrisXFVec4* pv1)	{ return XFpuMtx44TransformXYZ(pv0, pm0, pv1); }
STATICINLINE IrisBool		XFpuMtx44IsIdentity(const IrisXFMtx44* pm0)	{ return XFpuMtx44IsUnit(pm0); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFMatrix44.inl"
#endif

#endif
