//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFMatrix33.h
 * @brief		3x3}gbNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFMatrix33_H_
#define INCG_IRIS_MathXFMatrix33_H_

//======================================================================
// include
#include "MathXFpuDef.h"
#include "MathXFVector3.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Unit(IrisXFMtx33* pm0);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Zero(IrisXFMtx33* pm0);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Copy(IrisXFMtx33* pm0, const IrisXFMtx33* pm1);
IRIS_XFPU_INLINE IrisXFVec3*	XFpuMtx33Transform(IrisXFVec3* pv0, const IrisXFMtx33* pm0, const IrisXFVec3* pv1);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Mul(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, const IrisXFMtx33* pm2);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Scale(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, xf32 s);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Transpose(IrisXFMtx33* pm0, const IrisXFMtx33* pm1);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotZ(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, xf32 rz);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotIdxZ(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, u16 idz);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotY(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, xf32 ry);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotIdxY(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, u16 idy);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotX(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, xf32 rx);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotIdxX(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, u16 idx);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Rot(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, const IrisXFVec3* pv0);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33RotIdx(IrisXFMtx33* pm0, const IrisXFMtx33* pm1, const IrisSVec3* pv0);
IRIS_XFPU_INLINE IrisBool		XFpuMtx33IsUnit(const IrisXFMtx33* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx33Trace(const IrisXFMtx33* pm0);
IRIS_XFPU_INLINE xf32			XFpuMtx33Determinant(const IrisXFMtx33* pm0);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Adjoint(IrisXFMtx33* pm0, const IrisXFMtx33* pm1);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Inverse(IrisXFMtx33* pm0, xf32* pDeterminant, const IrisXFMtx33* pm1);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33Normalize(IrisXFMtx33* pm0, const IrisXFMtx33* pm1);
IRIS_XFPU_INLINE IrisXFMtx33*	XFpuMtx33TruncatePrecision24(IrisXFMtx33* pm0, const IrisXFMtx33* pm1);

//======================================================================
// inline
STATICINLINE IrisXFMtx33*	XFpuMtx33Identity(IrisXFMtx33* pm0)			{ return XFpuMtx33Unit(pm0); }
STATICINLINE IrisXFMtx33*	XFpuMtx33Null(IrisXFMtx33* pm0)				{ return XFpuMtx33Zero(pm0); }
STATICINLINE IrisXFVec3*	XFpuMtx33Apply(IrisXFVec3* pv0, const IrisXFMtx33* pm0, const IrisXFVec3* pv1)	{ return XFpuMtx33Transform(pv0, pm0, pv1); }
STATICINLINE IrisBool		XFpuMtx33IsIdentity(const IrisXFMtx33* pm0)	{ return XFpuMtx33IsUnit(pm0); }

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFMatrix33.inl"
#endif

#endif
