//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		MathXFColor.h
 * @brief		J[Zt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_MathXFColor_H_
#define INCG_IRIS_MathXFColor_H_

//======================================================================
// include
#include "MathXFpuDef.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorSet(IrisXFColor* pc, xf32 r, xf32 g, xf32 b, xf32 a);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorSetRGB(IrisXFColor* pc, xf32 r, xf32 g, xf32 b);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorCopy(IrisXFColor* pc0, const IrisXFColor* pc1);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorZero(IrisXFColor* pc0);
IRIS_XFPU_INLINE IrisRGBA8888	XFpuColorToRGBA8888(const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisRGBA4444	XFpuColorToRGBA4444(const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisRGBA5551	XFpuColorToRGBA5551(const IrisXFColor* pc, xf32 q);
IRIS_XFPU_INLINE IrisRGB565		XFpuColorToRGB565(const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisXFCMY*		XFpuColorToCMY(IrisXFCMY*  pcmy, const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisXFCMYK*	XFpuColorToCMYK(IrisXFCMYK* pcmyk, const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisXFHSV*		XFpuColorToHSV(IrisXFHSV* phsv, const IrisXFColor* pc);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromRGBA8888(IrisXFColor* pc, IrisRGBA8888 rgba);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromRGBA4444(IrisXFColor* pc, IrisRGBA4444 rgba);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromRGBA5551(IrisXFColor* pc, IrisRGBA5551 rgba, xf32 q);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromRGB565(IrisXFColor* pc, IrisRGB565 rgb, xf32 q);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromCMY(IrisXFColor* pc, const IrisXFCMY* pcmy, xf32 q);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromCMYK(IrisXFColor* pc, const IrisXFCMYK* pcmyk, xf32 q);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorFromHSV(IrisXFColor* pc, const IrisXFHSV* phsv, xf32 q);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorAdd(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorAddRGB(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorSub(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorSubRGB(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorMul(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorMulRGB(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorNeg(IrisXFColor* pc0, const IrisXFColor* pc1);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorNegRGB(IrisXFColor* pc0, const IrisXFColor* pc1);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorLerp(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2, xf32 t);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorLerpRGB(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2, xf32 t);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorScale(IrisXFColor* pc0, const IrisXFColor* pc1, xf32 s);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorScaleRGB(IrisXFColor* pc0, const IrisXFColor* pc1, xf32 s);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorClamp(IrisXFColor* pc0, const IrisXFColor* pc1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorClampRGB(IrisXFColor* pc0, const IrisXFColor* pc1, xf32 min, xf32 max);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorMax(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorMin(IrisXFColor* pc0, const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisBool		XFpuColorIsEqual(const IrisXFColor* pc1, const IrisXFColor* pc2);
IRIS_XFPU_INLINE IrisBool		XFpuColorIsZero(const IrisXFColor* pc1);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorNormalize(IrisXFColor* pc0, const IrisXFColor* pc1);
IRIS_XFPU_INLINE IrisXFColor*	XFpuColorNormalizeRGB(IrisXFColor* pc0, const IrisXFColor* pc1);

}	// end of namespace xf
}	// end of namespace iris

#ifdef _IRIS_XFPU_INLINE
	#include "inl/MathXFColor.inl"
#endif

#endif
