//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFHermiteCurve.h
 * @brief		xf32 G~[gȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XFHermiteCurve_H_
#define INCG_IRIS_XFHermiteCurve_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace xf
{

//======================================================================
// declare
// G~[gȐԊ֐
STATICINLINE xf32	XF_HermiteCurve(xf32 pt0, xf32 vt0, xf32 pt1, xf32 vt1, xf32 t);

//======================================================================
// function
/**
 * @brief	G~[gȐԊ֐
 * @param [in]	pt0	= n_
 * @param [in]	vt0	= n__
 * @param [in]	pt1	= I_
 * @param [in]	vt1	= I__
 * @param [in]	t	= (0`1)
 * @return o͒l
*/
STATICINLINE xf32	XF_HermiteCurve(xf32 pt0, xf32 vt0, xf32 pt1, xf32 vt1, xf32 t)
{
	xf32 t2 = XF32_Mul(t, t);
	xf32 t3 = XF32_Mul(t, t2);
	return (XF32_Mul(pt0, (( 2 * t3) - (3 * t2) + XF32_ONE))
		+	XF32_Mul(vt0, ((     t3) - (2 * t2) + t       ))
		+	XF32_Mul(pt1, ((-2 * t3) + (3 * t2)           ))
		+	XF32_Mul(vt1, ((     t3) - (    t2)           ))
		);
}


}	// end of namespace xf
}	// end of namespace iris

#endif
