//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFBezierCurve.h
 * @brief		xf32 xWGȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XFBezierCurve_H_
#define INCG_IRIS_XFBezierCurve_H_

//======================================================================
// include
#include "../../iris_inchead.h"

namespace iris {
namespace xf
{

//======================================================================
// function
// xWGȐ
xf32	XF_BezierCurve(xf32 t, s32 n, ...);
// xWGȐ
xf32	XF_BezierCurveArray(xf32 t, s32 n, xf32 pt[]);

// NxNg̃xWGȐ
xf32*	XF_BezierCurveN(xf32* pV, s32 N, xf32 t, s32 n, ...);
// NxNg̃xWGȐ
xf32*	XF_BezierCurveArrayN(xf32* pV, s32 N, xf32 t, s32 n, xf32 pt[]);

}	// end of namespace xf
}	// end of namespace iris

#endif
