//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFBSplineCurve.cpp
 * @brief		xf32 B-XvCȐt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_XFBSplineCurve_CPP_

//======================================================================
// include
#include "XFBSplineCurve.h"
#include "XFPolynomial.h"
#include "../../iris_debug.h"

namespace iris {
namespace xf
{

//======================================================================
// function
/**********************************************************************//**
 *
 * B-XvCȐ
 *
 -----------------------------------------------------------------------
 * @param [in]	t	= ( 0 <= t <= 1)
 * @param [in]	nn	= mbg
 * @param [in]	nv	= mbg
 * @param [in]	np	= _̐
 * @param [in]	pt	= _̔z(n)
 * @return o͒l
*//***********************************************************************/
xf32	XF_BSplineCurveArray(xf32 t, s32 nn, xf32 nv[], s32 np, xf32 pt[])
{
	IRIS_ASSERT( nv != nullptr );
	IRIS_ASSERT( np >= 2 );
	IRIS_ASSERT( nn >= (np-1)*2 );
	IRIS_ASSERT( pt != nullptr );
	xf32 ret = XF32_ZERO;
	xf32* pp = pt;
	// TODO : Ȃ񂩊ԈĂ݂

	for( s32 i=0; i < np; ++i, ++pp )
	{
		ret += XF32_Mul( *pp, XF_BSplinePolynomial(nn, i, t, nv) );
	}
	return ret;
}

}	// end of namespace xf
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "../../unit/UnitCore.h"
#include "../../iris_using.h"
#include "../../iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CXFBSplineCurveUnitTest, XFBSplineCurveUnitTest)
{
	xf32 P[] = {
		XF32_CONST(0.0f),
		XF32_CONST(100.0f),
		XF32_CONST(0.0f),
		XF32_CONST(200.0f)
	};
	xf32 N[] = {
		XF32_CONST(1.0f),
		XF32_CONST(2.0f),
		XF32_CONST(3.0f),
		XF32_CONST(4.0f),
		XF32_CONST(5.0f),
		XF32_CONST(6.0f),
		XF32_CONST(7.0f),
		XF32_CONST(8.0f),
	};
	s32 NP = sizeof(P)/sizeof(xf32);
	s32 NN = sizeof(N)/sizeof(xf32);

	for( int i=0; i < 11; ++i )
	{
		std::cout << XF_BSplineCurveArray(XF32_CONST(i/10.0f), NN, N, NP, P) << std::endl;
	}
}

#endif // #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
