//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		XFPower.h
 * @brief		xf32 ׂt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_XFPower_H_
#define INCG_IRIS_XFPower_H_

//======================================================================
// include
#include "../iris_inchead.h"

namespace iris {
namespace xf
{

//======================================================================
// function
/**********************************************************************//**
 * @brief ׂ(xfΉ)
 * oCi@ɂׂ
*//***********************************************************************/
STATICINLINE xf32	XF_Pow(xf32 a, s32 n)
{
	s32 tmp = 0;
	xf32 ret = XF32_ONE;
	xf32 p   = a;
	s32 bit = 1;
	while(tmp != n)
	{
		if( (bit & n) != 0 )
		{
			tmp |= bit;
			ret = XF_Mul(ret, p);
		}
		p = XF_Mul(p, p);
		bit <<= 1;
	}
	return ret;
}

}	// end of namespace xf
}	// end of namespace iris

#endif
