//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		gt_inchead.h
 * @brief		google test include t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_gt_inchead_H_
#define INCG_IRIS_gt_inchead_H_

//======================================================================
// include
#include "../../iris_inchead.h"

#ifdef	_IRIS_SUPPORT_GOOGLETEST

//======================================================================
// define
#if		defined(IRIS_MWERKS)
#  define GTEST_HAS_POSIX_RE		0
#  define GTEST_FATAL_FAILURE		::testing::TestPartResultType::TPRT_FATAL_FAILURE
#  define GTEST_NONFATAL_FAILURE	::testing::TestPartResultType::TPRT_NONFATAL_FAILURE
#  include <stdio.posix.h>
#endif


#include <gtest/gtest.h>
#include "../../iris_iostream.h"

//======================================================================
// link
#if		defined(_WIN32) && defined(_MT)
#  if		defined(_DLL)
#    define GT_LIBNAME_MODE	"md"
#  else
#    define GT_LIBNAME_MODE	"mt"
#  endif

#  if		IRIS_MSC_AT_LEAST(_MSC_VER_VC9)
#    define GT_LIBNAME_VC		"2008"
#  else
#    define GT_LIBNAME_VC		"2005"
#  endif

#  if		defined(_WIN64)
#    define GT_LIBNAME_AMD64	"_amd64"
#  else
#    define GT_LIBNAME_AMD64	
#  endif

#  pragma comment( lib, "gtest_" \
	GT_LIBNAME_MODE		\
	GT_LIBNAME_VC		\
	GT_LIBNAME_AMD64	\
	IRIS_LIB_POSTFIX	\
	".lib" )

#endif

//======================================================================
// define
#define GT_INIT(pargc, argv)		::testing::InitGoogleTest(pargc, argv)

#undef ASSERT_TRUE
#define ASSERT_TRUE(condition) \
	GTEST_TEST_BOOLEAN_(condition ? true : false, #condition, false, true, \
                      GTEST_FATAL_FAILURE_)

#else

//======================================================================
// define
#define EXPECT_TRUE(condition)		(void)(condition)
#define EXPECT_FALSE(condition)		(void)(condition)
#define ASSERT_TRUE(condition)		(void)(condition)
#define ASSERT_FALSE(condition)		(void)(condition)

#define EXPECT_EQ(expected, actual) __noop
#define EXPECT_NE(expected, actual) __noop
#define EXPECT_LE(val1, val2)		__noop
#define EXPECT_LT(val1, val2)		__noop
#define EXPECT_GE(val1, val2)		__noop
#define EXPECT_GT(val1, val2)		__noop

#define ASSERT_EQ(expected, actual)	__noop
#define ASSERT_NE(val1, val2)		__noop
#define ASSERT_LE(val1, val2)		__noop
#define ASSERT_LT(val1, val2)		__noop
#define ASSERT_GE(val1, val2)		__noop
#define ASSERT_GT(val1, val2)		__noop

#define EXPECT_STREQ(expected, actual)		__noop
#define EXPECT_STRNE(s1, s2)				__noop
#define EXPECT_STRCASEEQ(expected, actual)	__noop
#define EXPECT_STRCASENE(s1, s2)			__noop

#define ASSERT_STREQ(expected, actual)		__noop
#define ASSERT_STRNE(s1, s2)				__noop
#define ASSERT_STRCASEEQ(expected, actual)	__noop
#define ASSERT_STRCASENE(s1, s2)			__noop

#define EXPECT_FLOAT_EQ(expected, actual)	__noop
#define EXPECT_DOUBLE_EQ(expected, actual)	__noop
#define ASSERT_FLOAT_EQ(expected, actual)	__noop
#define ASSERT_DOUBLE_EQ(expected, actual)	__noop
#define EXPECT_NEAR(val1, val2, abs_error)	__noop
#define ASSERT_NEAR(val1, val2, abs_error)	__noop

#define EXPECT_HRESULT_SUCCEEDED(expr)		__noop
#define ASSERT_HRESULT_SUCCEEDED(expr)		__noop
#define EXPECT_HRESULT_FAILED(expr)			__noop
#define ASSERT_HRESULT_FAILED(expr)			__noop

#if 0
#  define GTEST_TEST(test_case_name, test_name)		void test_case_name##_##test_name()
#  define TEST(test_case_name, test_name)			GTEST_TEST(test_case_name, test_name)
#  define TEST_F(test_fixture, test_name)			GTEST_TEST(test_fixture, test_name)
#else
#  include "../UnitCore.h"
#  define GTEST_TEST(test_case_name, test_name)		IRIS_UNITTEST(test_case_name, test_name)
#  define TEST(test_case_name, test_name)			GTEST_TEST(test_case_name, test_name)
#  define TEST_F(test_fixture, test_name)			IRIS_UNITTEST_FIX(test_fixture, test_name)
#endif

#define RUN_ALL_TESTS()						__noop
#define GT_INIT(pargc, argv)				__noop

//======================================================================
// class
namespace testing
{
	class Test
	{
	};
}

#endif

#define NO_TEST(test_case_name, test_name)			void test_case_name##_##test_name()

#endif
