//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		UnitFuctory.h
 * @brief		UnitTest Fuctory NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_UnitFuctory_H_
#define INCG_IRIS_UnitFuctory_H_

//======================================================================
// include
#include "UnitClass.h"

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )

namespace iris {
namespace unit
{

//======================================================================
// class
/**
 * eXgNXRN^
*/
class IUnitTestFuctory : public IIrisObject
{
public:
	IUnitTestFuctory*	m_next;
	const char*			m_name;
	const char*			m_subname;
public:
	// RXgN^
	IUnitTestFuctory(LPCSTR pName, LPCSTR pSubName);

public:
	// NXo^AhX̎擾
	static IUnitTestFuctory**	GetRegister(void);
	// eXg̎s
	virtual	void	Exec(void) = 0;
};

template<class _TC>
class CUnitTestFuctory : public IUnitTestFuctory
{
	PFN_UnitTestMain	m_pMain;
public:
	// RXgN^
	CUnitTestFuctory(LPCSTR pName, LPCSTR pSubName, PFN_UnitTestMain pMain)
		: IUnitTestFuctory(pName, pSubName)
		, m_pMain(pMain)	{}

public:
	// eXg̎s
	virtual	void	Exec(void)
	{
		_TC* p = new _TC;
		p->Exec(m_pMain);
		delete p;
	}
};


}	// end of namespace unit
}	// end of namespace iris

#endif

#endif
